/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1498;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.math.Quaternion;

public class HorseTracker
extends Tracker {
    double boostTrigger = 1.4;
    double pullTrigger = 0.8;
    int speedLevel = 0;
    int maxSpeedLevel = 3;
    int coolDownMillis = 500;
    long lastBoostMillis = -1L;
    double turnspeed = 6.0;
    double bodyturnspeed = 0.2;
    double baseSpeed = 0.2;
    class_1498 horse = null;
    ModelInfo info = new ModelInfo(this);

    public HorseTracker(class_310 mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 p) {
        return false;
    }

    @Override
    public void reset(class_746 player) {
        super.reset(player);
        if (this.horse != null) {
            this.horse.method_5977(false);
        }
    }

    @Override
    public void doProcess(class_746 player) {
        this.horse = (class_1498)player.method_5854();
        this.horse.method_5977(true);
        float f = (this.horse.method_36454() + 360.0f) % 360.0f;
        float f1 = (this.horse.field_6283 + 360.0f) % 360.0f;
        class_243 vec3 = this.dh.vr.controllerHistory[1].netMovement(0.1).method_1021(10.0);
        class_243 vec31 = this.dh.vr.controllerHistory[0].netMovement(0.1).method_1021(10.0);
        double d0 = Math.min(-vec3.field_1351, -vec31.field_1351);
        if (d0 > this.boostTrigger) {
            this.boost();
        }
        Quaternion quaternion = new Quaternion(0.0f, -this.horse.field_6283, 0.0f);
        class_243 vec32 = quaternion.multiply(new class_243(0.0, 0.0, -1.0));
        class_243 vec33 = quaternion.multiply(new class_243(1.0, 0.0, 0.0));
        class_243 vec34 = quaternion.multiply(new class_243(-1.0, 0.0, 0.0));
        Quaternion quaternion1 = new Quaternion(0.0f, VRSettings.inst.worldRotation, 0.0f);
        class_243 vec35 = VRPlayer.get().roomOrigin.method_1019(quaternion1.multiply(this.dh.vr.controllerHistory[1].latest()));
        class_243 vec36 = VRPlayer.get().roomOrigin.method_1019(quaternion1.multiply(this.dh.vr.controllerHistory[0].latest()));
        double d1 = vec35.method_1020(this.info.leftReinPos).method_1026(vec32) + vec35.method_1020(this.info.leftReinPos).method_1026(vec33);
        double d2 = vec36.method_1020(this.info.rightReinPos).method_1026(vec32) + vec36.method_1020(this.info.rightReinPos).method_1026(vec34);
        if (this.speedLevel < 0) {
            this.speedLevel = 0;
        }
        if (d1 > this.pullTrigger + 0.3 && d2 > this.pullTrigger + 0.3 && Math.abs(d2 - d1) < 0.1) {
            if (this.speedLevel <= 0 && System.currentTimeMillis() > this.lastBoostMillis + (long)this.coolDownMillis) {
                this.speedLevel = -1;
            } else {
                this.doBreak();
            }
        } else {
            double d3 = 0.0;
            double d4 = 0.0;
            if (d1 > this.pullTrigger) {
                d3 = d1 - this.pullTrigger;
            }
            if (d2 > this.pullTrigger) {
                d4 = d2 - this.pullTrigger;
            }
            this.horse.method_36456((float)((double)f + (d4 - d3) * this.turnspeed));
        }
        this.horse.field_6283 = (float)Utils.lerpMod(f1, f, this.bodyturnspeed, 360.0);
        this.horse.field_6241 = f;
        class_243 vec37 = quaternion.multiply(new class_243(0.0, 0.0, (double)this.speedLevel * this.baseSpeed));
        this.horse.method_18800(vec37.field_1352, this.horse.method_18798().field_1351, vec37.field_1350);
    }

    boolean boost() {
        if (this.speedLevel >= this.maxSpeedLevel) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + (long)this.coolDownMillis) {
            return false;
        }
        ++this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    boolean doBreak() {
        if (this.speedLevel <= 0) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + (long)this.coolDownMillis) {
            return false;
        }
        System.out.println("Breaking");
        --this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    public class ModelInfo {
        public class_243 leftReinPos = class_243.field_1353;
        public class_243 rightReinPos = class_243.field_1353;

        public ModelInfo(HorseTracker this$0) {
        }
    }
}

