/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.mixin.accessor.GameRendererAccessor;
import forge.me.thosea.badoptimizations.other.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.effect.MobEffects;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class MixinLightmapManager {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private boolean allowUpdate = false;
    @Unique
    private int lastTick = -1;
    @Unique
    private boolean previousHasLightning;
    @Unique
    private double previousGamma;
    @Unique
    private DimensionSpecialEffects previousDimension;
    @Unique
    private boolean previousInWater;
    @Unique
    private long previousTime;
    @Unique
    private boolean previousHasNightVision;
    @Unique
    private float previousSkyDarkness;
    @Unique
    private GameRendererAccessor gameRendererAccessor;

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/Minecraft;)V"}, at={@At(value="TAIL")})
    private void onInit(GameRenderer renderer, Minecraft client, CallbackInfo ci) {
        this.gameRendererAccessor = (GameRendererAccessor)renderer;
    }

    @Unique
    private boolean isREALLYDirty() {
        boolean hasNightVision;
        float skyDarkness;
        long time;
        boolean inWater;
        DimensionSpecialEffects dimension;
        double gamma;
        boolean hasLightning;
        boolean result = false;
        boolean bl = hasLightning = this.minecraft.level.getSkyFlashTime() != 0;
        if (hasLightning != this.previousHasLightning) {
            this.previousHasLightning = hasLightning;
            result = true;
        }
        if (this.previousGamma != (gamma = ((Double)this.minecraft.options.gamma().get()).doubleValue())) {
            this.previousGamma = gamma;
            result = true;
        }
        if (this.previousDimension != (dimension = this.minecraft.level.effects())) {
            this.previousDimension = dimension;
            result = true;
        }
        if (this.previousInWater != (inWater = this.minecraft.player.isUnderWater())) {
            this.previousInWater = inWater;
            result = true;
        }
        if (Math.abs((time = this.minecraft.level.getDayTime()) - this.previousTime) >= (long)Config.lightmap_time_change_needed_for_update) {
            this.previousTime = time;
            result = true;
        }
        if (this.previousSkyDarkness != (skyDarkness = this.gameRendererAccessor.getDarkenWorldAmount())) {
            this.previousSkyDarkness = skyDarkness;
            result = true;
        }
        if (this.previousHasNightVision != (hasNightVision = this.minecraft.player.hasEffect(MobEffects.NIGHT_VISION))) {
            this.previousHasNightVision = hasNightVision;
            result = true;
        }
        return result;
    }

    @Inject(method={"turnOnLightLayer()V"}, at={@At(value="TAIL")})
    private void onEnable(CallbackInfo ci) {
        if (this.minecraft.player == null) {
            return;
        }
        int tick = this.minecraft.player.tickCount;
        if (this.lastTick != tick) {
            this.lastTick = tick;
            if (this.isREALLYDirty()) {
                this.allowUpdate = true;
                this.tick();
                this.allowUpdate = false;
            }
        }
    }

    @Shadow
    public abstract void tick();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTick(CallbackInfo ci) {
        if (!this.allowUpdate) {
            ci.cancel();
        }
    }
}

