/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.interfaces.BiomeSkyColorGetter;
import forge.me.thosea.badoptimizations.other.Config;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientWorld
extends Level {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private BiomeSkyColorGetter biomeColors;
    @Unique
    private Vec3 skyColorCache;
    @Unique
    private int lastTick;
    @Unique
    private long previousTime;
    @Unique
    private int previousBiomeColor;
    @Unique
    private Vec3 biomeColorVector;
    @Unique
    private float previousRainGradient;
    @Unique
    private float rainGradientMultiplier;
    @Unique
    private float previousThunderGradient;
    @Unique
    private float thunderGradientMultiplier;
    @Unique
    private int previousLightningTicks;

    @Inject(method={"getSkyColor(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetColorHead(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        if (this.skyColorCache == null || this.minecraft.player == null) {
            return;
        }
        int tick = this.minecraft.player.tickCount;
        if (this.lastTick != tick) {
            int lightningTicks;
            float thunderGradient;
            this.lastTick = tick;
            boolean doMiniUpdate = false;
            float rainGradient = this.getRainLevel(tickDelta);
            if (this.previousRainGradient != rainGradient) {
                this.previousRainGradient = rainGradient;
                doMiniUpdate = true;
                this.rainGradientMultiplier = rainGradient > 0.0f ? 1.0f - rainGradient * 0.75f : 0.0f;
            }
            if (this.previousThunderGradient != (thunderGradient = this.getThunderLevel(tickDelta))) {
                this.previousThunderGradient = thunderGradient;
                doMiniUpdate = true;
                this.thunderGradientMultiplier = thunderGradient > 0.0f ? 1.0f - thunderGradient * 0.75f : 0.0f;
            }
            if (this.previousLightningTicks != (lightningTicks = this.getSkyFlashTime())) {
                doMiniUpdate = true;
                this.previousLightningTicks = lightningTicks;
            }
            if (this.isBiomeDirty(cameraPos.subtract(2.0, 2.0, 2.0).scale(0.25))) {
                return;
            }
            long time = this.getDayTime();
            if (doMiniUpdate || Math.abs(time - this.previousTime) >= (long)Config.skycolor_time_change_needed_for_update) {
                this.previousTime = time;
                this.calcSkyColor(tickDelta);
            }
        }
        cir.setReturnValue((Object)this.skyColorCache);
    }

    @Unique
    private boolean isBiomeDirty(Vec3 pos) {
        int z;
        int y;
        int x = Mth.floor((double)pos.x);
        int color = this.biomeColors.get(x - 2, (y = Mth.floor((double)pos.y)) - 2, (z = Mth.floor((double)pos.z)) - 2);
        if (this.previousBiomeColor != color) {
            this.previousBiomeColor = color;
            this.biomeColorVector = Vec3.fromRGB24((int)color);
            return true;
        }
        return this.biomeColors.get(x + 3, y + 3, z + 3) != color;
    }

    @Shadow
    public abstract int getSkyFlashTime();

    @Shadow
    public abstract Vec3 getSkyColor(Vec3 var1, float var2);

    @Unique
    private void calcSkyColor(float delta) {
        double color;
        float angle = Mth.cos((float)(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        angle = Mth.clamp((float)angle, (float)0.0f, (float)1.0f);
        double x = this.biomeColorVector.x * (double)angle;
        double y = this.biomeColorVector.y * (double)angle;
        double z = this.biomeColorVector.z * (double)angle;
        if (this.rainGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.6f;
            x = x * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
            y = y * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
            z = z * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
        }
        if (this.thunderGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.2f;
            x = x * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
            y = y * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
            z = z * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
        }
        if (this.previousLightningTicks > 0) {
            float lightningMultiplier = (float)this.previousLightningTicks - delta;
            if (lightningMultiplier > 1.0f) {
                lightningMultiplier = 1.0f;
            }
            x = x * (double)(1.0f - (lightningMultiplier *= 0.45f)) + (double)(0.8f * lightningMultiplier);
            y = y * (double)(1.0f - lightningMultiplier) + (double)(0.8f * lightningMultiplier);
            z = z * (double)(1.0f - lightningMultiplier) + (double)lightningMultiplier;
        }
        this.skyColorCache = new Vec3(x, y, z);
    }

    @Inject(method={"getSkyColor(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private void onGetColorTail(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        this.skyColorCache = (Vec3)cir.getReturnValue();
    }

    @Inject(method={"<init>(Lnet/minecraft/client/multiplayer/ClientPacketListener;Lnet/minecraft/client/multiplayer/ClientLevel$ClientLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/Holder;IILjava/util/function/Supplier;Lnet/minecraft/client/renderer/LevelRenderer;ZJ)V"}, at={@At(value="TAIL")})
    private void afterInit(CallbackInfo ci) {
        this.lastTick = -1;
        this.previousBiomeColor = Integer.MIN_VALUE;
        this.biomeColorVector = Vec3.ZERO;
        this.biomeColors = BiomeSkyColorGetter.of(this.getBiomeManager());
    }

    protected MixinClientWorld(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
        throw new AssertionError((Object)"nuh uh");
    }
}

