/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.thosea.badoptimizations.mixin.tick;

import fabric.me.thosea.badoptimizations.interfaces.BiomeSkyColorGetter;
import fabric.me.thosea.badoptimizations.other.Config;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_638.class})
public abstract class MixinClientWorld
extends class_1937 {
    @Shadow
    @Final
    private class_310 field_3729;
    @Unique
    private BiomeSkyColorGetter biomeColors;
    @Unique
    private class_243 skyColorCache;
    @Unique
    private int lastTick;
    @Unique
    private long previousTime;
    @Unique
    private int previousBiomeColor;
    @Unique
    private class_243 biomeColorVector;
    @Unique
    private float previousRainGradient;
    @Unique
    private float rainGradientMultiplier;
    @Unique
    private float previousThunderGradient;
    @Unique
    private float thunderGradientMultiplier;
    @Unique
    private int previousLightningTicks;

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetColorHead(class_243 cameraPos, float tickDelta, CallbackInfoReturnable<class_243> cir) {
        if (this.skyColorCache == null || this.field_3729.field_1724 == null) {
            return;
        }
        int tick = this.field_3729.field_1724.field_6012;
        if (this.lastTick != tick) {
            int lightningTicks;
            float thunderGradient;
            this.lastTick = tick;
            boolean doMiniUpdate = false;
            float rainGradient = this.method_8430(tickDelta);
            if (this.previousRainGradient != rainGradient) {
                this.previousRainGradient = rainGradient;
                doMiniUpdate = true;
                this.rainGradientMultiplier = rainGradient > 0.0f ? 1.0f - rainGradient * 0.75f : 0.0f;
            }
            if (this.previousThunderGradient != (thunderGradient = this.method_8478(tickDelta))) {
                this.previousThunderGradient = thunderGradient;
                doMiniUpdate = true;
                this.thunderGradientMultiplier = thunderGradient > 0.0f ? 1.0f - thunderGradient * 0.75f : 0.0f;
            }
            if (this.previousLightningTicks != (lightningTicks = this.method_23789())) {
                doMiniUpdate = true;
                this.previousLightningTicks = lightningTicks;
            }
            if (this.isBiomeDirty(cameraPos.method_1023(2.0, 2.0, 2.0).method_1021(0.25))) {
                return;
            }
            long time = this.method_8532();
            if (doMiniUpdate || Math.abs(time - this.previousTime) >= (long)Config.skycolor_time_change_needed_for_update) {
                this.previousTime = time;
                this.calcSkyColor(tickDelta);
            }
        }
        cir.setReturnValue((Object)this.skyColorCache);
    }

    @Unique
    private boolean isBiomeDirty(class_243 pos) {
        int z;
        int y;
        int x = class_3532.method_15357((double)pos.field_1352);
        int color = this.biomeColors.get(x - 2, (y = class_3532.method_15357((double)pos.field_1351)) - 2, (z = class_3532.method_15357((double)pos.field_1350)) - 2);
        if (this.previousBiomeColor != color) {
            this.previousBiomeColor = color;
            this.biomeColorVector = class_243.method_24457((int)color);
            return true;
        }
        return this.biomeColors.get(x + 3, y + 3, z + 3) != color;
    }

    @Shadow
    public abstract int method_23789();

    @Shadow
    public abstract class_243 method_23777(class_243 var1, float var2);

    @Unique
    private void calcSkyColor(float delta) {
        double color;
        float angle = class_3532.method_15362((float)(this.method_30274(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        angle = class_3532.method_15363((float)angle, (float)0.0f, (float)1.0f);
        double x = this.biomeColorVector.field_1352 * (double)angle;
        double y = this.biomeColorVector.field_1351 * (double)angle;
        double z = this.biomeColorVector.field_1350 * (double)angle;
        if (this.rainGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.6f;
            x = x * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
            y = y * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
            z = z * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
        }
        if (this.thunderGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.2f;
            x = x * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
            y = y * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
            z = z * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
        }
        if (this.previousLightningTicks > 0) {
            float lightningMultiplier = (float)this.previousLightningTicks - delta;
            if (lightningMultiplier > 1.0f) {
                lightningMultiplier = 1.0f;
            }
            x = x * (double)(1.0f - (lightningMultiplier *= 0.45f)) + (double)(0.8f * lightningMultiplier);
            y = y * (double)(1.0f - lightningMultiplier) + (double)(0.8f * lightningMultiplier);
            z = z * (double)(1.0f - lightningMultiplier) + (double)lightningMultiplier;
        }
        this.skyColorCache = new class_243(x, y, z);
    }

    @Inject(method={"getSkyColor"}, at={@At(value="RETURN")})
    private void onGetColorTail(class_243 cameraPos, float tickDelta, CallbackInfoReturnable<class_243> cir) {
        this.skyColorCache = (class_243)cir.getReturnValue();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void afterInit(CallbackInfo ci) {
        this.lastTick = -1;
        this.previousBiomeColor = Integer.MIN_VALUE;
        this.biomeColorVector = class_243.field_1353;
        this.biomeColors = BiomeSkyColorGetter.of(this.method_22385());
    }

    protected MixinClientWorld(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
        throw new AssertionError((Object)"nuh uh");
    }
}

