/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.util;

import com.ishland.earlyloadingscreen.LoadingProgressManager;
import com.ishland.earlyloadingscreen.SharedConstants;
import com.ishland.earlyloadingscreen.patch.SodiumOSDetectionPatch;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.loader.api.FabricLoader;
import org.lwjgl.glfw.GLFW;

public class WindowCreationUtil {
    private static AtomicBoolean ranSodiumHookInit = new AtomicBoolean(false);
    private static boolean foundSodium = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long warpGlfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        FabricLoader.getInstance().invokeEntrypoints("els_before_window_creation", Runnable.class, Runnable::run);
        WindowCreationUtil.sodiumHookInit();
        WindowCreationUtil.sodiumHook(false);
        try {
            long l = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
            return l;
        }
        finally {
            WindowCreationUtil.sodiumHook(true);
            FabricLoader.getInstance().invokeEntrypoints("els_after_window_creation", Runnable.class, Runnable::run);
        }
    }

    private static void sodiumHookInit() {
        if (Boolean.getBoolean("earlyloadingscreen.duringEarlyLaunch") && !SodiumOSDetectionPatch.INITIALIZED) {
            String msg = "SodiumOSDetectionPatch unavailable, sodium workarounds may not work properly";
            SharedConstants.LOGGER.warn("SodiumOSDetectionPatch unavailable, sodium workarounds may not work properly");
            LoadingProgressManager.showMessageAsProgress("SodiumOSDetectionPatch unavailable, sodium workarounds may not work properly");
            return;
        }
        if (ranSodiumHookInit.compareAndSet(false, true)) {
            Class<?> workaroundsClazz;
            Class<?> graphicsAdapterProbeClazz;
            if (!FabricLoader.getInstance().isModLoaded("sodium")) {
                foundSodium = false;
                SharedConstants.LOGGER.info("Sodium not found, skipping sodium hook init");
                return;
            }
            try {
                graphicsAdapterProbeClazz = WindowCreationUtil.locateClass("me.jellysquid.mods.sodium.client.util.workarounds.probe.GraphicsAdapterProbe", "me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterProbe");
                workaroundsClazz = WindowCreationUtil.locateClass("me.jellysquid.mods.sodium.client.util.workarounds.Workarounds", "me.jellysquid.mods.sodium.client.compatibility.workarounds.Workarounds");
            }
            catch (Throwable t) {
                String msg = "Failed to find Sodium workarounds, skipping sodium hook init";
                if (FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.getBoolean("els.debug")) {
                    SharedConstants.LOGGER.warn("Failed to find Sodium workarounds, skipping sodium hook init", t);
                } else {
                    SharedConstants.LOGGER.warn("Failed to find Sodium workarounds, skipping sodium hook init");
                }
                LoadingProgressManager.showMessageAsProgress("Failed to find Sodium workarounds, skipping sodium hook init");
                foundSodium = false;
                return;
            }
            try {
                graphicsAdapterProbeClazz.getMethod("findAdapters", new Class[0]).invoke(null, new Object[0]);
                workaroundsClazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                String msg = "Failed to init Sodium workarounds, skipping sodium hook";
                if (FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.getBoolean("els.debug")) {
                    SharedConstants.LOGGER.warn("Failed to init Sodium workarounds, skipping sodium hook", t);
                } else {
                    SharedConstants.LOGGER.warn("Failed to init Sodium workarounds, skipping sodium hook");
                }
                LoadingProgressManager.showMessageAsProgress("Failed to init Sodium workarounds, skipping sodium hook");
                foundSodium = false;
                return;
            }
        }
    }

    private static void sodiumHook(boolean after) {
        Class<?> nvidiaWorkaroundsClazz;
        Class<?> workaroundsReferenceClazz;
        Class<?> workaroundsClazz;
        if (!foundSodium) {
            return;
        }
        try {
            workaroundsClazz = WindowCreationUtil.locateClass("me.jellysquid.mods.sodium.client.util.workarounds.Workarounds", "me.jellysquid.mods.sodium.client.compatibility.workarounds.Workarounds");
            workaroundsReferenceClazz = WindowCreationUtil.locateClass("me.jellysquid.mods.sodium.client.util.workarounds.Workarounds$Reference", "me.jellysquid.mods.sodium.client.compatibility.workarounds.Workarounds$Reference");
            nvidiaWorkaroundsClazz = WindowCreationUtil.locateClass("me.jellysquid.mods.sodium.client.util.workarounds.driver.nvidia.NvidiaWorkarounds", "me.jellysquid.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaWorkarounds");
        }
        catch (Throwable e) {
            String msg = "Failed to find Sodium workarounds, skipping sodium hook";
            if (FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.getBoolean("els.debug")) {
                SharedConstants.LOGGER.warn("Failed to find Sodium workarounds, skipping sodium hook", e);
            } else {
                SharedConstants.LOGGER.warn("Failed to find Sodium workarounds, skipping sodium hook");
            }
            LoadingProgressManager.showMessageAsProgress("Failed to find Sodium workarounds, skipping sodium hook");
            foundSodium = false;
            return;
        }
        try {
            Object NVIDIA_THREADED_OPTIMIZATIONS = Enum.valueOf(workaroundsReferenceClazz, "NVIDIA_THREADED_OPTIMIZATIONS");
            if (((Boolean)workaroundsClazz.getMethod("isWorkaroundEnabled", workaroundsReferenceClazz).invoke(null, NVIDIA_THREADED_OPTIMIZATIONS)).booleanValue()) {
                if (!after) {
                    nvidiaWorkaroundsClazz.getMethod("install", new Class[0]).invoke(null, new Object[0]);
                    LoadingProgressManager.showMessageAsProgress("Installed Nvidia workarounds from sodium", 5000L);
                } else {
                    nvidiaWorkaroundsClazz.getMethod("uninstall", new Class[0]).invoke(null, new Object[0]);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static Class<?> locateClass(String ... names) {
        for (String name : names) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RuntimeException("Failed to locate any of " + String.join((CharSequence)", ", names));
    }
}

