/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.platform_cl;

import com.ishland.earlyloadingscreen.platform_cl.LaunchPoint;
import com.ishland.earlyloadingscreen.platform_cl.PlatformUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final String MIXIN_PREFIX = "mixin.";
    public static final boolean REUSE_EARLY_WINDOW;
    public static final boolean ENABLE_ENTRYPOINT_INFORMATION;
    public static final boolean ENABLE_MIXIN_PRETRANSFORM;
    public static final boolean ALLOW_EARLY_WINDOW_CLOSE;
    public static final LaunchPoint WINDOW_CREATION_POINT;
    public static final List<String> DISABLED_MIXINS;

    public static void init() {
    }

    private static int getInt(Properties properties, Properties newProperties, String key, int def, StringBuilder comment) {
        comment.append(key).append(" default: ").append(def).append("\n");
        try {
            int i = Integer.parseInt(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, "default");
            return def;
        }
    }

    private static boolean getBoolean(Properties properties, Properties newProperties, String key, boolean def, StringBuilder comment) {
        comment.append(key).append(" default: ").append(def).append("\n");
        try {
            boolean b = Config.parseBoolean(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(b));
            return b;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, "default");
            return def;
        }
    }

    private static <T extends Enum<T>> T getEnum(Class<T> clazz, Properties properties, Properties newProperties, String key, T def, StringBuilder comment) {
        comment.append(key).append(" available [default] options: ");
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            if (constant == def) {
                comment.append('[');
            }
            comment.append(constant.name());
            if (constant == def) {
                comment.append(']');
            }
            comment.append(' ');
        }
        try {
            T configured = Enum.valueOf(clazz, String.valueOf(properties.getProperty(key)));
            newProperties.setProperty(key, String.valueOf(configured));
            return configured;
        }
        catch (IllegalArgumentException e) {
            newProperties.setProperty(key, "default");
            return def;
        }
    }

    private static boolean parseBoolean(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (string.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (string.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new NumberFormatException(string);
    }

    static {
        DISABLED_MIXINS = new ArrayList<String>();
        Properties properties = new Properties();
        Properties newProperties = new Properties();
        Path path = FabricLoader.getInstance().getConfigDir().resolve("early-loading-screen.properties");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Early loading screen configuration file\n");
        REUSE_EARLY_WINDOW = !PlatformUtil.IS_WINDOWS && Config.getBoolean(properties, newProperties, "reuse_early_window", true, sb);
        ENABLE_ENTRYPOINT_INFORMATION = Config.getBoolean(properties, newProperties, "enable_entrypoint_information", true, sb);
        ENABLE_MIXIN_PRETRANSFORM = Config.getBoolean(properties, newProperties, "enable_mixin_pretransform", false, sb);
        ALLOW_EARLY_WINDOW_CLOSE = Config.getBoolean(properties, newProperties, "allow_early_window_close", true, sb);
        LaunchPoint defaultPoint = FabricLoader.getInstance().isModLoaded("immediatelyfast") ? LaunchPoint.mixinLoad : LaunchPoint.postModLoading;
        WINDOW_CREATION_POINT = Config.getEnum(LaunchPoint.class, properties, newProperties, "window_creation_point", defaultPoint, sb);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String mixin;
            String key = (String)entry.getKey();
            if (!key.startsWith(MIXIN_PREFIX) || (mixin = key.substring(MIXIN_PREFIX.length())).isBlank()) continue;
            if (Config.parseBoolean((String)entry.getValue())) {
                newProperties.setProperty(key, "true");
                continue;
            }
            newProperties.setProperty(key, "false");
            DISABLED_MIXINS.add(mixin);
        }
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            newProperties.store(out, sb.toString().trim().indent(1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

