/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.patch;

import com.ishland.earlyloadingscreen.LoadingProgressManager;
import com.ishland.earlyloadingscreen.SharedConstants;
import com.ishland.earlyloadingscreen.patch.BytecodeTransformer;
import com.ishland.earlyloadingscreen.patch.PatchUtil;
import com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport;
import com.ishland.earlyloadingscreen.util.AppLoaderUtil;
import java.lang.instrument.Instrumentation;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FabricLoaderInvokePatch
implements BytecodeTransformer {
    private static final FabricLoaderInvokePatch INSTANCE = new FabricLoaderInvokePatch();

    private FabricLoaderInvokePatch() {
    }

    public static void init() {
    }

    private static void initTransformer() {
        Instrumentation inst = PatchUtil.instrumentation;
        if (inst == null) {
            SharedConstants.LOGGER.warn("Instrumentation unavailable, entrypoint information will not be available");
            LoadingProgressManager.showMessageAsProgress("Instrumentation unavailable, entrypoint information will not be available");
            return;
        }
        try {
            FabricLoaderInvokePatch.updateAppLoaderAccess(inst);
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.warn("Failed to update AppLoader access", t);
        }
        try {
            AppLoaderUtil.init();
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.warn("Failed to define classes on AppClassLoader, entrypoint information will not be available", t);
            LoadingProgressManager.showMessageAsProgress("Failed to define classes on AppClassLoader, entrypoint information will not be available");
            return;
        }
        PatchUtil.transformers.add(INSTANCE);
        try {
            inst.retransformClasses(Class.forName("net.fabricmc.loader.impl.launch.knot.KnotClassDelegate"));
            inst.retransformClasses(FabricLoaderImpl.class);
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.warn("Failed to retransform FabricLoaderImpl, attempting to revert changes", t);
            LoadingProgressManager.showMessageAsProgress("Failed to retransform EntrypointUtils, entrypoint information will not be available");
            PatchUtil.transformers.remove(INSTANCE);
            try {
                inst.retransformClasses(Class.forName("net.fabricmc.loader.impl.launch.knot.KnotClassDelegate"));
            }
            catch (Throwable t2) {
                SharedConstants.LOGGER.warn("Failed to revert changes to EntrypointUtils", t2);
            }
            try {
                inst.retransformClasses(FabricLoaderImpl.class);
            }
            catch (Throwable t2) {
                SharedConstants.LOGGER.warn("Failed to revert changes to FabricLoaderImpl", t2);
            }
        }
    }

    private static void updateAppLoaderAccess(Instrumentation inst) {
        inst.redefineModule(ModuleLayer.boot().findModule("java.base").get(), Set.of(), Map.of(), Map.of("java.lang", Set.of(PatchUtil.class.getModule())), Set.of(), Map.of());
    }

    @Override
    public boolean transform(String className, ClassNode node) {
        if (className.equals("net/fabricmc/loader/impl/FabricLoaderImpl")) {
            SharedConstants.LOGGER.info("Patching FabricLoaderImpl for entrypoint information");
            for (MethodNode method : node.methods) {
                int progressTrackerIndex;
                if (!method.name.equals("invokeEntrypoints") || !method.desc.equals("(Ljava/lang/String;Ljava/lang/Class;Ljava/util/function/Consumer;)V")) continue;
                SharedConstants.LOGGER.info("Patching FabricLoaderImpl.invokeEntrypoints");
                LocalVariableNode firstLocalVar = (LocalVariableNode)method.localVariables.get(0);
                ++method.maxLocals;
                method.visitLocalVariable("early_loading_screen$progressTracker", Type.getDescriptor(AppLoaderAccessSupport.ProgressHolderAccessor.class), null, firstLocalVar.start.getLabel(), firstLocalVar.end.getLabel(), progressTrackerIndex);
                int iteratorVarIndex = -1;
                int listVarIndex = -1;
                ListIterator iterator = method.instructions.iterator();
                while (iterator.hasNext()) {
                    LabelNode labelNode;
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (insn instanceof MethodInsnNode) {
                        VarInsnNode varInsnNode;
                        AbstractInsnNode next;
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                        if (methodInsnNode.owner.equals("net/fabricmc/loader/impl/FabricLoaderImpl") && methodInsnNode.name.equals("getEntrypointContainers") && methodInsnNode.desc.equals("(Ljava/lang/String;Ljava/lang/Class;)Ljava/util/List;")) {
                            iterator.add(new MethodInsnNode(184, "com/google/common/collect/Lists", "newArrayList", "(Ljava/lang/Iterable;)Ljava/util/ArrayList;", false));
                            next = (AbstractInsnNode)iterator.next();
                            if (!(next instanceof VarInsnNode) || (varInsnNode = (VarInsnNode)next).getOpcode() != 58) {
                                throw new IllegalStateException("Expected VarInsnNode, got %s".formatted(next.getClass().getName()));
                            }
                            listVarIndex = varInsnNode.var;
                            iterator.previous();
                        }
                        if (methodInsnNode.owner.equals("java/util/Collection") && methodInsnNode.name.equals("iterator") && methodInsnNode.desc.equals("()Ljava/util/Iterator;")) {
                            iterator.previous();
                            iterator.add(new TypeInsnNode(192, "java/util/List"));
                            iterator.next();
                            iterator.set(new MethodInsnNode(185, "java/util/List", "listIterator", "()Ljava/util/ListIterator;", true));
                            next = (AbstractInsnNode)iterator.next();
                            if (!(next instanceof VarInsnNode)) {
                                throw new IllegalStateException("Expected VarInsnNode after iterator call, but got %s".formatted(next.getClass().getName()));
                            }
                            varInsnNode = (VarInsnNode)next;
                            iteratorVarIndex = varInsnNode.var;
                            iterator.previous();
                        }
                        if (methodInsnNode.owner.equals("java/util/Iterator") && methodInsnNode.name.equals("next") && methodInsnNode.desc.equals("()Ljava/lang/Object;")) {
                            next = (AbstractInsnNode)iterator.next();
                            if (next.getOpcode() != 192) {
                                throw new IllegalStateException("Expected CHECKCAST after iterator.next() call, but got %s".formatted(next.getClass().getName()));
                            }
                            if (listVarIndex == -1) {
                                throw new IllegalStateException("listVarIndex not found");
                            }
                            if (iteratorVarIndex == -1) {
                                throw new IllegalStateException("iteratorVarIndex not found");
                            }
                            iterator.add(new InsnNode(89));
                            iterator.add(new VarInsnNode(25, progressTrackerIndex));
                            iterator.add(new VarInsnNode(25, listVarIndex));
                            iterator.add(new VarInsnNode(25, iteratorVarIndex));
                            iterator.add(new VarInsnNode(25, 1));
                            iterator.add(new MethodInsnNode(184, "com/ishland/earlyloadingscreen/platform_cl/AppLoaderAccessSupport", "onEntrypointInvoke", "(Lnet/fabricmc/loader/api/entrypoint/EntrypointContainer;Lcom/ishland/earlyloadingscreen/platform_cl/AppLoaderAccessSupport$ProgressHolderAccessor;Ljava/util/List;Ljava/util/ListIterator;Ljava/lang/String;)V", false));
                            iterator.previous();
                        }
                    }
                    if (insn instanceof LabelNode && (labelNode = (LabelNode)insn) == firstLocalVar.start) {
                        iterator.add(new MethodInsnNode(184, "com/ishland/earlyloadingscreen/platform_cl/AppLoaderAccessSupport", "tryCreateProgressHolder", "()Lcom/ishland/earlyloadingscreen/platform_cl/AppLoaderAccessSupport$ProgressHolderAccessor;", false));
                        iterator.add(new VarInsnNode(58, progressTrackerIndex));
                    }
                    if (insn.getOpcode() != 177) continue;
                    LabelNode continueLabel = new LabelNode();
                    iterator.previous();
                    iterator.add(new VarInsnNode(25, progressTrackerIndex));
                    iterator.add(new JumpInsnNode(198, continueLabel));
                    iterator.add(new VarInsnNode(25, progressTrackerIndex));
                    iterator.add(new MethodInsnNode(185, "java/io/Closeable", "close", "()V", true));
                    iterator.add(continueLabel);
                    iterator.next();
                }
            }
            return true;
        }
        if (className.equals("net/fabricmc/loader/impl/launch/knot/KnotClassDelegate")) {
            SharedConstants.LOGGER.info("Patching KnotClassDelegate for class loader issues");
            for (MethodNode method : node.methods) {
                if (!method.name.equals("loadClass") || !method.desc.equals("(Ljava/lang/String;Z)Ljava/lang/Class;")) continue;
                SharedConstants.LOGGER.info("Patching KnotClassDelegate.loadClass");
                LocalVariableNode firstLocalVar = (LocalVariableNode)method.localVariables.get(0);
                ListIterator iterator = method.instructions.iterator();
                while (iterator.hasNext()) {
                    LabelNode labelNode;
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (!(insn instanceof LabelNode) || (labelNode = (LabelNode)insn) != firstLocalVar.start) continue;
                    LabelNode continueLabel = new LabelNode();
                    iterator.add(new VarInsnNode(25, 1));
                    iterator.add(new LdcInsnNode((Object)"com.ishland.earlyloadingscreen.platform_cl."));
                    iterator.add(new MethodInsnNode(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false));
                    iterator.add(new JumpInsnNode(153, continueLabel));
                    iterator.add(new VarInsnNode(25, 0));
                    iterator.add(new VarInsnNode(25, 0));
                    iterator.add(new FieldInsnNode(180, "net/fabricmc/loader/impl/launch/knot/KnotClassDelegate", "parentClassLoader", "Ljava/lang/ClassLoader;"));
                    iterator.add(new VarInsnNode(25, 1));
                    iterator.add(new MethodInsnNode(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false));
                    iterator.add(new InsnNode(176));
                    iterator.add(continueLabel);
                }
            }
            return true;
        }
        return false;
    }

    static {
        FabricLoaderInvokePatch.initTransformer();
    }
}

