/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen;

import com.ishland.earlyloadingscreen.LoadingProgressManager;
import com.ishland.earlyloadingscreen.platform_cl.Config;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.service.MixinService;

public class TheMod
implements ModInitializer {
    public void onInitialize() {
        if (Config.ENABLE_MIXIN_PRETRANSFORM) {
            TheMod.auditMixins();
        }
    }

    private static void auditMixins() {
        block13: {
            Logger auditLogger = LoggerFactory.getLogger((String)"EarlyLoadingScreen Mixin Audit");
            try {
                Class<?> transformerClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinTransformer");
                if (!transformerClazz.isInstance(MixinEnvironment.getCurrentEnvironment().getActiveTransformer())) break block13;
                Field processorField = transformerClazz.getDeclaredField("processor");
                processorField.setAccessible(true);
                Object processor = processorField.get(MixinEnvironment.getCurrentEnvironment().getActiveTransformer());
                Class<?> processorClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinProcessor");
                Field configsField = processorClazz.getDeclaredField("configs");
                configsField.setAccessible(true);
                List configs = (List)configsField.get(processor);
                Class<?> configClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinConfig");
                Method getUnhandledTargetsMethod = configClazz.getDeclaredMethod("getUnhandledTargets", new Class[0]);
                getUnhandledTargetsMethod.setAccessible(true);
                HashSet unhandled = new HashSet();
                for (Object config : configs) {
                    Set unhandledTargets = (Set)getUnhandledTargetsMethod.invoke(config, new Object[0]);
                    unhandled.addAll(unhandledTargets);
                }
                try (LoadingProgressManager.ProgressHolder progressHolder = LoadingProgressManager.tryCreateProgressHolder();){
                    int index = 0;
                    int total = unhandled.size();
                    for (String s : unhandled) {
                        if (progressHolder != null) {
                            int finalIndex = index;
                            progressHolder.update(() -> String.format("Loading class (%d/%d): %s ", finalIndex, total, s));
                        }
                        MixinService.getService().getClassProvider().findClass(s, false);
                        ++index;
                    }
                }
                for (Object config : configs) {
                    for (String unhandledTarget : (Set)getUnhandledTargetsMethod.invoke(config, new Object[0])) {
                        auditLogger.error("{} is already classloaded", (Object)unhandledTarget);
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to audit mixins", t);
            }
        }
    }
}

