/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ishland.earlyloadingscreen.LoadingProgressManager;
import com.ishland.earlyloadingscreen.SharedConstants;
import com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport;
import com.ishland.earlyloadingscreen.platform_cl.Config;
import com.ishland.earlyloadingscreen.platform_cl.PlatformUtil;
import com.ishland.earlyloadingscreen.render.GLText;
import com.ishland.earlyloadingscreen.render.Simple2DDraw;
import com.ishland.earlyloadingscreen.util.WindowCreationUtil;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.util.Arguments;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class LoadingScreenManager {
    public static final Cleaner CLEANER = Cleaner.create();
    public static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EarlyLoadingScreen Scheduler").build());
    private static long handle;
    public static final WindowEventLoop windowEventLoop;
    public static boolean eventLoopStarted;
    private static final Object windowEventLoopSync;

    public static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createWindow() {
        Object object = windowEventLoopSync;
        synchronized (object) {
            if (handle != 0L || eventLoopStarted) {
                return;
            }
            SharedConstants.LOGGER.info("Creating early window...");
            try {
                LoadingScreenManager.initGLFW();
                if (!PlatformUtil.IS_WINDOWS) {
                    handle = LoadingScreenManager.initWindow();
                }
            }
            catch (Throwable t) {
                SharedConstants.LOGGER.error("Failed to create early window", t);
                return;
            }
            eventLoopStarted = true;
            windowEventLoop.start();
            GLFW.glfwPollEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long takeContext() {
        Object object = windowEventLoopSync;
        synchronized (object) {
            if (handle == 0L) {
                return 0L;
            }
            SharedConstants.LOGGER.info("Handing early window to Minecraft...");
            LoadingScreenManager.windowEventLoop.running.set(false);
            eventLoopStarted = true;
            while (windowEventLoop.isAlive()) {
                LockSupport.parkNanos("Waiting for window event loop to exit", 100000L);
            }
            long handle1 = handle;
            handle = 0L;
            if (!Config.REUSE_EARLY_WINDOW) {
                LoadingScreenManager.windowEventLoop.renderLoop = null;
            }
            return handle1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInitLoop() {
        Object object = windowEventLoopSync;
        synchronized (object) {
            if (LoadingScreenManager.windowEventLoop.renderLoop != null) {
                SharedConstants.LOGGER.info("Reinitializing screen rendering...");
                LoadingScreenManager.windowEventLoop.renderLoop = new RenderLoop();
            }
        }
    }

    public static WindowSettings getWindowSettings() {
        return new WindowSettings(LoadingScreenManager.windowEventLoop.framebufferWidth, LoadingScreenManager.windowEventLoop.framebufferHeight, LoadingScreenManager.windowEventLoop.windowWidth, LoadingScreenManager.windowEventLoop.windowHeight);
    }

    private static void initGLFW() {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerBuffer);
            if (i != 0) {
                long l = pointerBuffer.get();
                String string1 = l == 0L ? "" : MemoryUtil.memUTF8((long)l);
                throw new IllegalStateException(String.format(Locale.ROOT, "GLFW error before init: [0x%X]%s", i, string1));
            }
        }
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback((code, pointer) -> list.add(String.format(Locale.ROOT, "GLFW error during init: [0x%X]%s", code, pointer)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        for (String string : list) {
            SharedConstants.LOGGER.error("GLFW error collected during initialization: {}", (Object)string);
        }
        LoadingScreenManager._glfwSetErrorCallback(gLFWErrorCallback);
    }

    private static void _glfwSetErrorCallback(GLFWErrorCallback gLFWErrorCallback) {
        GLFWErrorCallback old = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)gLFWErrorCallback);
        if (old != null) {
            old.free();
        }
    }

    private static void throwGlError(int error, long description) {
        String string = "GLFW error " + error + ": " + MemoryUtil.memUTF8((long)description);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(string + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new RuntimeException(string);
    }

    private static long initWindow() {
        GLFW.glfwSetErrorCallback(LoadingScreenManager::throwGlError);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        int configuredWidth = 854;
        int configuredHeight = 480;
        try {
            Arguments arguments = FabricLoaderImpl.INSTANCE.getGameProvider().getArguments();
            configuredWidth = Integer.parseInt(arguments.getOrDefault("width", "854"));
            configuredHeight = Integer.parseInt(arguments.getOrDefault("height", "480"));
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.error("Failed to load window configuration", t);
        }
        String minecraftVersion = "Unknown";
        try {
            minecraftVersion = FabricLoader.getInstance().getModContainer("minecraft").map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).get();
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.error("Failed to load Minecraft version", t);
        }
        long handle = WindowCreationUtil.warpGlfwCreateWindow(configuredWidth, configuredHeight, "Minecraft* %s".formatted(minecraftVersion), 0L, 0L);
        int[] width0 = new int[1];
        int[] height0 = new int[1];
        GLFW.glfwGetFramebufferSize((long)handle, (int[])width0, (int[])height0);
        LoadingScreenManager.windowEventLoop.framebufferWidth = width0[0];
        LoadingScreenManager.windowEventLoop.framebufferHeight = height0[0];
        GLFW.glfwGetWindowSize((long)handle, (int[])width0, (int[])height0);
        LoadingScreenManager.windowEventLoop.windowWidth = width0[0];
        LoadingScreenManager.windowEventLoop.windowHeight = height0[0];
        GLFW.glfwSetFramebufferSizeCallback((long)handle, (window, width, height) -> {
            LoadingScreenManager.windowEventLoop.framebufferWidth = width;
            LoadingScreenManager.windowEventLoop.framebufferHeight = height;
        });
        GLFW.glfwSetWindowPosCallback((long)handle, (window, xpos, ypos) -> {});
        GLFW.glfwSetWindowSizeCallback((long)handle, (window, width, height) -> {
            LoadingScreenManager.windowEventLoop.windowWidth = width;
            LoadingScreenManager.windowEventLoop.windowHeight = height;
        });
        GLFW.glfwSetWindowFocusCallback((long)handle, (window, focused) -> {});
        GLFW.glfwSetCursorEnterCallback((long)handle, (window, entered) -> {});
        GLFW.glfwSetWindowContentScaleCallback((long)handle, (window, xscale, yscale) -> {
            LoadingScreenManager.windowEventLoop.scale = Math.max(xscale, yscale);
        });
        return handle;
    }

    public static void spinWaitInit() {
        if (!LoadingScreenManager.windowEventLoop.initialized) {
            while (!LoadingScreenManager.windowEventLoop.initialized && windowEventLoop.isAlive()) {
                Thread.onSpinWait();
            }
        }
    }

    static {
        eventLoopStarted = false;
        windowEventLoopSync = new Object();
        SharedConstants.LOGGER.info("Initializing LoadingScreenManager...");
        windowEventLoop = new WindowEventLoop(PlatformUtil.IS_WINDOWS);
        AppLoaderAccessSupport.setAccess(LoadingProgressManager::tryCreateProgressHolder);
    }

    public static class WindowEventLoop
    extends Thread
    implements Executor {
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
        private volatile boolean needsCreateWindow;
        private volatile boolean initialized = false;
        public volatile RenderLoop renderLoop = null;
        private volatile int framebufferWidth = 0;
        private volatile int framebufferHeight = 0;
        private volatile int windowWidth = 0;
        private volatile int windowHeight = 0;
        private volatile float scale = 1.0f;

        private WindowEventLoop(boolean needsCreateWindow) {
            super("EarlyLoadingScreen - Render Thread");
            this.needsCreateWindow = needsCreateWindow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long handle;
                if (this.needsCreateWindow) {
                    LoadingScreenManager.handle = handle = LoadingScreenManager.initWindow();
                } else {
                    handle = LoadingScreenManager.handle;
                }
                GLFW.glfwMakeContextCurrent((long)handle);
                GL.createCapabilities();
                GL32.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLFW.glfwSwapInterval((int)1);
                RenderLoop renderLoop = this.renderLoop = new RenderLoop();
                this.initialized = true;
                long lastFpsTime = System.nanoTime();
                int fpsCounter = 0;
                int fps = 0;
                long lastFrameTime = System.nanoTime();
                GLText glt = renderLoop.glt;
                while (this.running.get()) {
                    Runnable runnable;
                    while ((runnable = this.queue.poll()) != null) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    if (GLFW.glfwWindowShouldClose((long)handle)) {
                        if (Config.ALLOW_EARLY_WINDOW_CLOSE) {
                            GLFW.glfwDestroyWindow((long)handle);
                            SharedConstants.LOGGER.info("Early window closed");
                            System.exit(0);
                        } else {
                            GLFW.glfwSetWindowShouldClose((long)handle, (boolean)false);
                        }
                    }
                    GL32.glClear((int)16640);
                    GL11.glViewport((int)0, (int)0, (int)this.framebufferWidth, (int)this.framebufferHeight);
                    renderLoop.render(this.framebufferWidth, this.framebufferHeight, this.scale);
                    if (!PlatformUtil.IS_OSX) {
                        GLFW.glfwPollEvents();
                    }
                    GLFW.glfwSwapBuffers((long)handle);
                    ++fpsCounter;
                    long currentTime = System.nanoTime();
                    if (currentTime - lastFpsTime >= 1000000000L) {
                        fps = (int)((long)fpsCounter * 1000000000L / (currentTime - lastFpsTime));
                        fpsCounter = 0;
                        lastFpsTime = currentTime;
                        GLText.gltSetText(renderLoop.fpsText, "%d fps".formatted(fps));
                    }
                    while (System.nanoTime() - lastFrameTime + 100000L < 16666666L) {
                        LockSupport.parkNanos(100000L);
                    }
                    lastFrameTime = System.nanoTime();
                }
            }
            catch (Throwable t) {
                SharedConstants.LOGGER.error("Failed to render early window, exiting", t);
                this.renderLoop = null;
            }
            finally {
                long handle1 = handle;
                if (handle1 != 0L) {
                    Callbacks.glfwFreeCallbacks((long)handle1);
                } else {
                    SharedConstants.LOGGER.warn("Early exit");
                }
                GLFW.glfwMakeContextCurrent((long)0L);
                this.needsCreateWindow = false;
                this.initialized = true;
            }
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.queue.add(command);
        }

        public void setWindowTitle(CharSequence title) {
            if (handle != 0L) {
                if (this.needsCreateWindow) {
                    this.execute(() -> GLFW.glfwSetWindowTitle((long)handle, (CharSequence)title));
                } else {
                    GLFW.glfwSetWindowTitle((long)handle, (CharSequence)title);
                }
            }
        }
    }

    public static class RenderLoop {
        public GLText glt = new GLText();
        public final GLText.GLTtext memoryUsage = GLText.gltCreateText();
        public final GLText.GLTtext fpsText = GLText.gltCreateText();
        private final GLText.GLTtext progressText = GLText.gltCreateText();
        public Simple2DDraw draw = new Simple2DDraw();
        public final Simple2DDraw.BufferBuilder progressBars = new Simple2DDraw.BufferBuilder(this.draw);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(int width, int height, float scale) {
            CopyOnWriteArrayList<LoadingProgressManager.Progress> activeProgress;
            this.glt.gltViewport(width, height);
            this.draw.viewport(width, height);
            GL11.glEnable((int)3042);
            CopyOnWriteArrayList<LoadingProgressManager.Progress> copyOnWriteArrayList = activeProgress = LoadingProgressManager.getActiveProgress();
            synchronized (copyOnWriteArrayList) {
                this.progressBars.begin();
                ListIterator<LoadingProgressManager.Progress> iterator = activeProgress.listIterator(activeProgress.size());
                float y = height;
                float textHeight = GLText.gltGetLineHeight(scale * 1.0f);
                while (iterator.hasPrevious()) {
                    LoadingProgressManager.Progress progress = iterator.previous();
                    if (progress.get().isBlank()) continue;
                    y -= textHeight;
                    float progress1 = progress.getProgress();
                    if (!(progress1 > 0.0f)) continue;
                    this.progressBars.rect(0.0f, y, progress1 * (float)width, textHeight, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                this.progressBars.end();
                this.progressBars.draw();
            }
            try (Closeable ignored = this.glt.gltBeginDraw();){
                this.glt.gltColor(1.0f, 1.0f, 1.0f, 1.0f);
                GLText.gltSetText(this.memoryUsage, "Memory: %d/%d MiB".formatted((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L, Runtime.getRuntime().maxMemory() / 1024L / 1024L));
                this.glt.gltDrawText2DAligned(this.memoryUsage, width, 0.0f, scale * 1.0f, 2, 0);
                this.glt.gltDrawText2DAligned(this.fpsText, 0.0f, 0.0f, scale * 1.0f, 0, 0);
                StringBuilder sb = new StringBuilder();
                CopyOnWriteArrayList<LoadingProgressManager.Progress> copyOnWriteArrayList2 = activeProgress;
                synchronized (copyOnWriteArrayList2) {
                    for (LoadingProgressManager.Progress progress : activeProgress) {
                        String str = progress.get();
                        if (str.isBlank()) continue;
                        sb.append(str).append('\n');
                    }
                }
                GLText.gltSetText(this.progressText, sb.toString().trim());
                this.glt.gltDrawText2DAligned(this.progressText, 0.0f, height, scale * 1.0f, 0, 2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            GL11.glDisable((int)3042);
        }

        private void terminate() {
            this.glt.gltTerminate();
        }
    }

    public record WindowSettings(int framebufferWidth, int framebufferHeight, int windowWidth, int windowHeight) {
    }
}

