/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen;

import com.ishland.earlyloadingscreen.LoadingScreenManager;
import com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class LoadingProgressManager {
    private static final CopyOnWriteArrayList<Progress> activeProgress = new CopyOnWriteArrayList();

    static CopyOnWriteArrayList<Progress> getActiveProgress() {
        return activeProgress;
    }

    public static ProgressHolder tryCreateProgressHolder() {
        return new ProgressHolder();
    }

    public static void showMessageAsProgress(String message) {
        LoadingProgressManager.showMessageAsProgress(message, 10000L);
    }

    public static void showMessageAsProgress(String message, long timeMillis) {
        ProgressHolder holder = LoadingProgressManager.tryCreateProgressHolder();
        if (holder != null) {
            ScheduledFuture<?> future = LoadingScreenManager.SCHEDULER.schedule(holder::close, timeMillis, TimeUnit.MILLISECONDS);
            holder.update(() -> String.format("(%ds) %s", future.getDelay(TimeUnit.SECONDS), message));
            holder.updateProgress(() -> Float.valueOf(1.0f - (float)future.getDelay(TimeUnit.MILLISECONDS) / (float)timeMillis));
        }
    }

    static {
        ProgressHolder.class.getName();
        Progress.class.getName();
    }

    public static class ProgressHolder
    implements AppLoaderAccessSupport.ProgressHolderAccessor {
        private final Progress impl;

        public ProgressHolder() {
            Progress progress = this.impl = new Progress();
            LoadingScreenManager.CLEANER.register(this, () -> activeProgress.remove(progress));
            activeProgress.add(this.impl);
        }

        @Override
        public void update(Supplier<String> text) {
            this.impl.update(text);
        }

        @Override
        public void updateProgress(Supplier<Float> progress) {
            this.impl.updateProgress(progress);
        }

        @Override
        public void close() {
            activeProgress.remove(this.impl);
        }
    }

    static class Progress {
        private volatile Supplier<String> supplier;
        private String text = "";
        private volatile Supplier<Float> progressSupplier;

        Progress() {
        }

        public void update(Supplier<String> text) {
            this.supplier = text;
        }

        public void updateProgress(Supplier<Float> progressSupplier) {
            this.progressSupplier = progressSupplier;
        }

        public String get() {
            Supplier<String> supplier = this.supplier;
            if (supplier == null) {
                return "";
            }
            return supplier.get();
        }

        public float getProgress() {
            Supplier<Float> floatSupplier = this.progressSupplier;
            return floatSupplier != null ? floatSupplier.get().floatValue() : 0.0f;
        }

        private String get0() {
            try {
                return this.supplier.get();
            }
            catch (Throwable t) {
                return "Error: " + t.getMessage();
            }
        }
    }
}

