/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen;

import com.ishland.earlyloadingscreen.deps.bytebuddy.agent.ByteBuddyAgent;
import com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport;
import com.ishland.earlyloadingscreen.platform_cl.Config;
import com.ishland.earlyloadingscreen.platform_cl.LaunchPoint;
import com.ishland.earlyloadingscreen.util.AppLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.game.minecraft.MinecraftGameProvider;

public class EarlyLaunch {
    static void load0(LaunchPoint point) {
        ClassLoader classLoader = EarlyLaunch.class.getClassLoader();
        Config.init();
        if (Config.WINDOW_CREATION_POINT.ordinal() > point.ordinal()) {
            return;
        }
        System.out.println(String.format("Loading EarlyLoadingScreen early on ClassLoader %s", classLoader.getClass().getName()));
        String earlyLaunchProperty = "earlyloadingscreen.duringEarlyLaunch";
        try {
            System.setProperty("earlyloadingscreen.duringEarlyLaunch", "true");
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            EarlyLaunch.unlockLibraryOnKnot(contextClassLoader);
            if (contextClassLoader.getClass().isInstance(classLoader)) {
                EarlyLaunch.launch(contextClassLoader.loadClass("com.ishland.earlyloadingscreen.Launch"));
            } else {
                System.out.println("Relaunching on context classloader");
                Instrumentation inst = ByteBuddyAgent.install();
                inst.redefineModule(ModuleLayer.boot().findModule("java.base").get(), Set.of(), Map.of(), Map.of("java.lang", Set.of(EarlyLaunch.class.getModule())), Set.of(), Map.of());
                AppLoaderAccessSupport.class.getName();
                AppLoaderAccessSupport.LoadingScreenAccessor.class.getName();
                AppLoaderAccessSupport.ProgressHolderAccessor.class.getName();
                Class<?> launchClass = EarlyLaunch.defineClass(contextClassLoader, "com.ishland.earlyloadingscreen.Launch");
                EarlyLaunch.launch(launchClass);
                System.out.println("[EarlyLoadingScreen] Relaunched on context classloader");
            }
        }
        catch (Throwable t) {
            System.clearProperty("earlyloadingscreen.duringEarlyLaunch");
            System.out.println("[EarlyLoadingScreen] Failed to launch early");
            t.printStackTrace();
        }
    }

    private static void launch(Class<?> launchClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        launchClass.getMethod("initAndCreateWindow", Boolean.TYPE).invoke(null, true);
    }

    private static void unlockLibraryOnKnot(ClassLoader knotClassLoader) {
        try {
            Method getDelegate = knotClassLoader.getClass().getDeclaredMethod("getDelegate", new Class[0]);
            getDelegate.setAccessible(true);
            Object knotClassLoaderDelegate = getDelegate.invoke((Object)knotClassLoader, new Object[0]);
            Class<?> delegateClazz = Class.forName("net.fabricmc.loader.impl.launch.knot.KnotClassDelegate");
            MinecraftGameProvider gameProvider = (MinecraftGameProvider)FabricLoaderImpl.INSTANCE.getGameProvider();
            Field getMiscGameLibraries = MinecraftGameProvider.class.getDeclaredField("miscGameLibraries");
            getMiscGameLibraries.setAccessible(true);
            List miscGameLibraries = (List)getMiscGameLibraries.get(gameProvider);
            Method setAllowedPrefixes = delegateClazz.getDeclaredMethod("setAllowedPrefixes", Path.class, String[].class);
            setAllowedPrefixes.setAccessible(true);
            Method addCodeSource = delegateClazz.getDeclaredMethod("addCodeSource", Path.class);
            addCodeSource.setAccessible(true);
            for (Path library : miscGameLibraries) {
                setAllowedPrefixes.invoke(knotClassLoaderDelegate, library, new String[0]);
                addCodeSource.invoke(knotClassLoaderDelegate, library);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to unlock library on knot", t);
        }
    }

    public static Class<?> defineClass(ClassLoader classLoader, String name) throws IllegalAccessException, InvocationTargetException, IOException, NoSuchMethodException {
        Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineClass.setAccessible(true);
        return (Class)defineClass.invoke((Object)classLoader, name, EarlyLaunch.getClassFile(name), 0, EarlyLaunch.getClassFile(name).length);
    }

    private static byte[] getClassFile(String name) throws IOException {
        try (InputStream in = AppLoaderUtil.class.getClassLoader().getResourceAsStream(name.replace('.', '/') + ".class");){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }
}

