/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerFunctions {
    public static boolean respawnPlayer(Level world, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        MinecraftServer server = world.getServer();
        ServerPlayer serverplayer = (ServerPlayer)player;
        if (serverplayer.wonGame) {
            serverplayer.wonGame = false;
            serverplayer = server.getPlayerList().respawn(serverplayer, true);
            CriteriaTriggers.CHANGED_DIMENSION.trigger(serverplayer, Level.END, Level.OVERWORLD);
        } else if (serverplayer.getHealth() <= 0.0f) {
            server.getPlayerList().respawn(serverplayer, false);
        }
        return true;
    }

    public static Player matchPlayer(Player player, String other) {
        return PlayerFunctions.matchPlayer(player.level(), other);
    }

    public static Player matchPlayer(Level world, String other) {
        List players = world.players();
        for (Player onlineplayer : players) {
            if (!onlineplayer.getName().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(Player player) {
        return player.getItemInHand(InteractionHand.OFF_HAND).getItem().equals(Items.WATER_BUCKET) || player.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(Items.WATER_BUCKET);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false, true);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory, boolean mustBeCloseToSpawn) {
        String firstjointag = "collective.firstJoin." + modid;
        String playerName = player.getName().getString();
        Set tags = player.getTags();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.addTag(firstjointag);
        if (mustHaveEmptyInventory) {
            Inventory inv = player.getInventory();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                if (inv.getItem(i).isEmpty()) continue;
                isempty = false;
                break;
            }
            if (!isempty) {
                Constants.LOG.debug("[" + modid + "] Inventory of " + playerName + " is not empty, first join is false.");
                return false;
            }
        }
        if (mustBeCloseToSpawn) {
            Level level = player.getCommandSenderWorld();
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos spawnPos = serverPlayer.getRespawnPosition();
            if (spawnPos == null) {
                spawnPos = serverLevel.getSharedSpawnPos();
            }
            Constants.LOG.debug("[" + modid + "] Checking for first join of " + playerName + " with spawn position: " + spawnPos.toShortString());
            BlockPos playerPos = player.blockPosition();
            BlockPos checkPos = new BlockPos(playerPos.getX(), spawnPos.getY(), playerPos.getZ());
            int spawnRadius = ((GameRules.IntegerValue)serverLevel.getGameRules().getRule(GameRules.RULE_SPAWN_RADIUS)).get();
            Constants.LOG.debug("[" + modid + "] Checking for first join of " + playerName + " with spawn radius: " + spawnRadius);
            return checkPos.closerThan((Vec3i)spawnPos, (double)(spawnRadius * 2));
        }
        return true;
    }

    public static BlockPos getSpawnPoint(Level world, Player player) {
        Vec3 spawnvec = PlayerFunctions.getSpawnVec(world, player);
        return BlockPos.containing((double)spawnvec.x, (double)spawnvec.y, (double)spawnvec.z);
    }

    public static Vec3 getSpawnVec(Level world, Player player) {
        Optional optionalbed;
        ServerPlayer serverplayer = (ServerPlayer)player;
        ServerLevel ServerLevel2 = (ServerLevel)world;
        BlockPos respawnlocation = ServerLevel2.getSharedSpawnPos();
        Vec3 respawnvec = new Vec3((double)respawnlocation.getX(), (double)respawnlocation.getY(), (double)respawnlocation.getZ());
        BlockPos bedpos = serverplayer.getRespawnPosition();
        if (bedpos != null && (optionalbed = Player.findRespawnPositionAndUseSpawnBlock((ServerLevel)ServerLevel2, (BlockPos)bedpos, (float)1.0f, (boolean)false, (boolean)false)).isPresent()) {
            Vec3 bedvec = (Vec3)optionalbed.get();
            BlockPos bp = BlockPos.containing((Position)bedvec);
            Iterator it = BlockPos.betweenClosedStream((int)(bp.getX() - 1), (int)(bp.getY() - 1), (int)(bp.getZ() - 1), (int)(bp.getX() + 1), (int)(bp.getY() + 1), (int)(bp.getZ() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                BlockState state = world.getBlockState(np);
                Block block = state.getBlock();
                if (!(block instanceof BedBlock)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static InteractionHand getOtherHand(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    public static String getPlayerGearString(Player player) {
        Level level = player.level();
        StringBuilder skconfig = new StringBuilder();
        ItemStack offhand = player.getItemBySlot(EquipmentSlot.OFFHAND);
        if (!offhand.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, offhand);
            skconfig.append("'offhand' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("'offhand' : '',");
        }
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!head.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, head);
            skconfig.append("\n'head' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'head' : '',");
        }
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!chest.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, chest);
            skconfig.append("\n'chest' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'chest' : '',");
        }
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        if (!legs.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, legs);
            skconfig.append("\n'legs' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'legs' : '',");
        }
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        if (!feet.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, feet);
            skconfig.append("\n'feet' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'feet' : '',");
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.getItem(i);
            if (!slot.isEmpty()) {
                String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, slot);
                skconfig.append("\n").append(i).append(" : ").append("'").append(nbtstring).append("',");
                continue;
            }
            skconfig.append("\n").append(i).append(" : '',");
        }
        return skconfig.toString();
    }

    public static String getPlayerGearStringFromHashMap(Level level, HashMap<String, ItemStack> gear) {
        StringBuilder gearstring = new StringBuilder();
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                specialslotstring = ItemFunctions.getNBTStringFromItemStack(level, gear.get(specialslot));
            }
            if (!gearstring.toString().equals("")) {
                gearstring.append("\n");
            }
            gearstring.append("'").append(specialslot).append("'").append(" : ").append("'").append(specialslotstring).append("',");
        }
        NonNullList emptyinventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                itemstring = ItemFunctions.getNBTStringFromItemStack(level, gear.get("" + i));
            }
            gearstring.append("\n").append(i).append(" : '").append(itemstring).append("',");
        }
        return gearstring.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void setPlayerGearFromString(Player player, String gearconfig) {
        Level level = player.level();
        String[] gearspl = gearconfig.split("',[\\r\\n]+");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        block18: for (String string : gearspl) {
            EquipmentSlot type;
            Optional optionalItemStack;
            void var9_9;
            String[] lspl;
            void var9_13;
            String string2 = string.trim();
            if (string2.endsWith(",")) {
                String string3 = string2.substring(0, string2.length() - 1);
            }
            if (!var9_13.endsWith("'")) {
                String string4 = (String)var9_13 + "'";
            }
            if ((lspl = var9_9.split(" : ")).length != 2) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The line " + (String)var9_9 + " is invalid.");
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if (data.startsWith("'")) {
                data = data.substring(1);
            }
            if (data.endsWith("'")) {
                data = data.substring(0, data.length() - 1);
            }
            if (data.length() < 2) continue;
            data = data.replaceAll("\r", "");
            ItemStack itemStack = null;
            try {
                CompoundTag compoundTag2 = TagParser.parseTag((String)data);
                optionalItemStack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)compoundTag2);
                if (optionalItemStack.isPresent()) {
                    itemStack = (ItemStack)optionalItemStack.get();
                }
            }
            catch (CommandSyntaxException compoundTag2) {
                // empty catch block
            }
            if (itemStack == null) {
                try {
                    data = data.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
                    CompoundTag compoundTag = TagParser.parseTag((String)data);
                    optionalItemStack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)compoundTag);
                    if (optionalItemStack.isPresent()) {
                        itemStack = (ItemStack)optionalItemStack.get();
                    }
                }
                catch (CommandSyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            if (itemStack == null) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: Unable to get the correct itemstack data from data " + data);
                return;
            }
            if (!cleared) {
                cleared = true;
                player.getInventory().clearContent();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.getInventory().setItem(slot, itemStack);
                continue;
            }
            switch (slotstring) {
                case "offhand": {
                    type = EquipmentSlot.OFFHAND;
                    break;
                }
                case "head": {
                    type = EquipmentSlot.HEAD;
                    break;
                }
                case "chest": {
                    type = EquipmentSlot.CHEST;
                    break;
                }
                case "legs": {
                    type = EquipmentSlot.LEGS;
                    break;
                }
                case "feet": {
                    type = EquipmentSlot.FEET;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            player.setItemSlot(type, itemStack);
        }
    }
}

