/*
 * Decompiled with CFR 0.152.
 */
package online.flowerinsnow.greatscrollabletooltips.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_310;
import online.flowerinsnow.fnml4j.api.node.IFNMLNode;
import online.flowerinsnow.fnml4j.api.node.ObjectNode;
import online.flowerinsnow.fnml4j.api.node.StringNode;
import online.flowerinsnow.fnml4j.api.parser.IFNMLNodeParser;
import online.flowerinsnow.fnml4j.api.parser.present.FNML4JPresentParser;
import online.flowerinsnow.fnml4j.core.FNML4J;
import online.flowerinsnow.greatscrollabletooltips.GreatScrollableTooltips;

@Environment(value=EnvType.CLIENT)
public class Config {
    private ObjectNode rootNode;
    public boolean enable;
    public int sensitivity;

    public void saveDefaultConfig() {
        BiConsumer<Throwable, String> crashFunction = this.crashFunction();
        Path configFile = this.getConfigFile();
        File file = configFile.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
                byte[] bytes = new byte[1024];
                try (InputStream in = GreatScrollableTooltips.class.getResourceAsStream("/config.conf");
                     FileOutputStream fos = new FileOutputStream(file);){
                    int len;
                    while ((len = in.read(bytes)) != -1) {
                        fos.write(bytes, 0, len);
                    }
                }
            }
            catch (IOException e) {
                crashFunction.accept(e, "Failed to save default config.");
            }
        }
    }

    public void load() {
        BiConsumer<Throwable, String> crashFunction = this.crashFunction();
        try {
            this.rootNode = FNML4J.parse((Path)this.getConfigFile(), (Charset)StandardCharsets.UTF_8);
            this.enable = (Boolean)this.rootNode.getChildNodeNotNull("enable", (IFNMLNodeParser)FNML4JPresentParser.BOOLEAN, StringNode.class);
            this.sensitivity = (Integer)this.rootNode.getChildNodeNotNull("sensitivity", (IFNMLNodeParser)FNML4JPresentParser.INT, StringNode.class);
        }
        catch (IOException e) {
            crashFunction.accept(e, "Failed to load config.");
        }
    }

    public void save() {
        BiConsumer<Throwable, String> crashFunction = this.crashFunction();
        try (FileWriter fw = new FileWriter(this.getConfigFile().toFile(), StandardCharsets.UTF_8);){
            this.rootNode.set("enable", (IFNMLNode)new StringNode(Boolean.toString(this.enable)));
            this.rootNode.set("sensitivity", (IFNMLNode)new StringNode(Integer.toString(this.sensitivity)));
            this.rootNode.writeRoot(0, (Writer)fw);
        }
        catch (IOException e) {
            crashFunction.accept(e, "Failed to save config.");
        }
    }

    public Path getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("great-scrollable-tooltips.conf");
    }

    private BiConsumer<Throwable, String> crashFunction() {
        return (e, msg) -> class_310.method_1551().method_54580(class_128.method_560((Throwable)e, (String)msg));
    }
}

