/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.fabric.mixin.perf.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBaker;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.DynamicBakedModelProvider;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1088.class}, priority=1100)
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    @Mutable
    public Map<class_2960, class_1100> field_5376;
    @Shadow
    @Final
    public static class_1091 field_5374;
    @Shadow
    @Final
    private Set<class_2960> field_5390;
    @Shadow
    @Final
    @Mutable
    private Map<class_2960, class_1087> field_5387;
    @Shadow
    @Final
    @Mutable
    private Map<class_1088.class_7776, class_1087> field_5398;
    @Shadow
    @Final
    @Mutable
    private class_324 field_20272;
    @Shadow
    @Final
    private static Logger field_5380;
    private Cache<class_1088.class_7776, class_1087> loadedBakedModels;
    private Cache<class_2960, class_1100> loadedModels;
    private HashMap<class_2960, class_1100> smallLoadingCache = new HashMap();
    private boolean ignoreModelLoad;
    private boolean fabric_enableGetOrLoadModelGuard;
    private class_1100 missingModel;
    private Set<class_2960> blockStateFiles;
    private Set<class_2960> modelFiles;
    private BiFunction<class_2960, class_4730, class_1058> textureGetter;
    private int mfix$nestedLoads = 0;

    @Shadow
    protected abstract void method_4715(class_2960 var1) throws Exception;

    @Shadow
    public abstract void method_4727(class_1091 var1);

    @Shadow
    public abstract class_1100 method_4726(class_2960 var1);

    @Redirect(method={"<init>"}, at=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/resources/model/ModelBakery;blockColors:Lnet/minecraft/client/color/block/BlockColors;"))
    private void replaceTopLevelBakedModels(class_1088 bakery, class_324 val) {
        this.fabric_enableGetOrLoadModelGuard = false;
        this.field_20272 = val;
        this.loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.loadedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).build();
        this.field_5398 = this.loadedBakedModels.asMap();
        final ConcurrentMap unbakedCacheBackingMap = this.loadedModels.asMap();
        this.field_5376 = new ForwardingMap<class_2960, class_1100>(){

            protected Map<class_2960, class_1100> delegate() {
                return unbakedCacheBackingMap;
            }

            public class_1100 put(class_2960 key, class_1100 value) {
                ModelBakeryMixin.this.smallLoadingCache.put(key, value);
                return (class_1100)super.put((Object)key, (Object)value);
            }
        };
        this.field_5387 = new DynamicBakedModelProvider((class_1088)this, this.field_5398);
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=0)})
    private void ignoreFutureModelLoads(CallbackInfo ci) {
        this.ignoreModelLoad = true;
    }

    private <K, V> void onModelRemoved(RemovalNotification<K, V> notification) {
        class_2960 rl;
        if (!debugDynamicModelLoading) {
            return;
        }
        Object k = notification.getKey();
        if (k == null) {
            return;
        }
        boolean baked = false;
        if (k instanceof class_2960) {
            rl = (class_2960)k;
        } else {
            rl = ((class_1088.class_7776)k).comp_1053();
            baked = true;
        }
        if (!baked && this.loadedModels.getIfPresent((Object)rl) != null) {
            return;
        }
        ModernFix.LOGGER.warn("Evicted {} model {}", (Object)(baked ? "baked" : "unbaked"), (Object)rl);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0), index=1)
    private Object captureMissingModel(Object model) {
        this.missingModel = (class_1100)model;
        this.blockStateFiles = new HashSet<class_2960>();
        this.modelFiles = new HashSet<class_2960>();
        return this.missingModel;
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelBakery;loadTopLevel(Lnet/minecraft/client/resources/model/ModelResourceLocation;)V"))
    private void addTopLevelFile(class_1088 bakery, class_1091 location) {
        if (location == field_5374 || !this.ignoreModelLoad) {
            this.method_4727(location);
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V", ordinal=0))
    private void fetchStaticDefinitions(Map<class_2960, class_2689<class_2248, class_2680>> map, BiConsumer<class_2960, class_2689<class_2248, class_2680>> func) {
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;", ordinal=0))
    private ImmutableList<class_2680> fetchBlocks(class_2689<class_2248, class_2680> def) {
        return ImmutableList.of();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;", ordinal=0))
    private Collection<?> copyTopLevelModelList(Map<?, ?> map) {
        return new ArrayList(map.values());
    }

    @Inject(method={"bakeModels"}, at={@At(value="HEAD")})
    private void captureGetter(BiFunction<class_2960, class_4730, class_1058> getter, CallbackInfo ci) {
        this.ignoreModelLoad = false;
        this.textureGetter = getter;
        DynamicBakedModelProvider.currentInstance = (DynamicBakedModelProvider)this.field_5387;
    }

    @Redirect(method={"bakeModels"}, at=@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;"))
    private Set<class_2960> skipBake(Map<class_2960, class_1100> instance) {
        HashSet<class_2960> modelSet = new HashSet<class_2960>(instance.keySet());
        if (modelSet.size() > 0) {
            ModernFix.LOGGER.info("Early baking {} models", (Object)modelSet.size());
        }
        return modelSet;
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object getMissingModel(Map map, Object rl) {
        if (rl == field_5374 && map == this.field_5376) {
            return this.missingModel;
        }
        return this.field_5376.get(rl);
    }

    @ModifyVariable(method={"cacheAndQueueDependencies"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1100 fireUnbakedEvent(class_1100 model, class_2960 location) {
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                model = integration.onUnbakedModelLoad(location, model, (class_1088)this);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model load event for {}", (Object)location, (Object)e);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadModelDynamic(class_2960 modelLocation, CallbackInfoReturnable<class_1100> cir) {
        if (modelLocation.equals((Object)field_5374)) {
            cir.setReturnValue((Object)this.missingModel);
            return;
        }
        class_1100 existing = this.field_5376.get(modelLocation);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                if (this.field_5390.contains(modelLocation)) {
                    throw new IllegalStateException("Circular reference while loading " + String.valueOf(modelLocation));
                }
                this.field_5390.add(modelLocation);
                class_1100 iunbakedmodel = this.missingModel;
                while (!this.field_5390.isEmpty()) {
                    class_2960 resourcelocation = this.field_5390.iterator().next();
                    ++this.mfix$nestedLoads;
                    try {
                        existing = this.field_5376.get(resourcelocation);
                        if (existing == null) {
                            if (debugDynamicModelLoading) {
                                field_5380.info("Loading {}", (Object)resourcelocation);
                            }
                            this.method_4715(resourcelocation);
                            continue;
                        }
                        this.smallLoadingCache.put(resourcelocation, existing);
                    }
                    catch (class_1088.class_1089 var9) {
                        field_5380.warn(var9.getMessage());
                        this.field_5376.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    catch (Exception var10) {
                        field_5380.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{resourcelocation, modelLocation, var10});
                        this.field_5376.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    finally {
                        --this.mfix$nestedLoads;
                        this.field_5390.remove(resourcelocation);
                    }
                }
                class_1100 result = this.smallLoadingCache.getOrDefault(modelLocation, iunbakedmodel);
                try {
                    result.method_45785(this::method_4726);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (this.mfix$nestedLoads == 0) {
                    this.smallLoadingCache.clear();
                }
                cir.setReturnValue((Object)result);
            }
        }
    }

    private <T extends Comparable<T>, V extends T> class_2680 setPropertyGeneric(class_2680 state, class_2769<T> prop, Object o) {
        return (class_2680)state.method_11657(prop, (Comparable)o);
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<class_2680> loadOnlyRelevantBlockState(class_2689<class_2248, class_2680> stateDefinition, class_2960 location) {
        if (!(location instanceof class_1091) || class_310.method_1551().field_1687 == null) {
            return stateDefinition.method_11662();
        }
        return ModelBakeryHelpers.getBlockStatesForMRL(stateDefinition, (class_1091)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public class_1087 bakeDefault(class_2960 modelLocation, class_3665 state) {
        class_1088 self;
        class_1088.class_7776 key = new class_1088.class_7776(modelLocation, class_1086.field_5350.method_3509(), class_1086.field_5350.method_3512());
        class_1087 m = (class_1087)this.loadedBakedModels.getIfPresent((Object)key);
        if (m != null) {
            return m;
        }
        class_1088 class_10882 = self = (class_1088)this;
        Objects.requireNonNull(class_10882);
        class_1088.class_7778 theBaker = new class_1088.class_7778(class_10882, this.textureGetter, modelLocation);
        ((IExtendedModelBaker)theBaker).throwOnMissingModel(true);
        ModelBakeryMixin modelBakeryMixin = this;
        synchronized (modelBakeryMixin) {
            m = theBaker.method_45873(modelLocation, state);
        }
        if (m != null) {
            this.loadedBakedModels.put((Object)key, (Object)m);
        }
        return m;
    }

    @Override
    public ImmutableList<class_2680> getBlockStatesForMRL(class_2689<class_2248, class_2680> stateDefinition, class_1091 location) {
        return this.loadOnlyRelevantBlockState(stateDefinition, (class_2960)location);
    }

    @Override
    public class_1100 mfix$getUnbakedMissingModel() {
        return this.missingModel;
    }
}

