/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.messaging;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.common.messaging.pluginmsg.AbstractPluginMessageMessenger;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class PluginMessageMessenger
extends AbstractPluginMessageMessenger
implements ServerPlayNetworking.PlayPayloadHandler<PluginMessagePayload> {
    private static final class_2960 CHANNEL = new class_2960("luckperms:update");
    private final LPFabricPlugin plugin;

    public PluginMessageMessenger(LPFabricPlugin plugin, IncomingMessageConsumer consumer) {
        super(consumer);
        this.plugin = plugin;
    }

    public void init() {
        PayloadTypeRegistry.playS2C().register(PluginMessagePayload.ID, PluginMessagePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PluginMessagePayload.ID, PluginMessagePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PluginMessagePayload.ID, (ServerPlayNetworking.PlayPayloadHandler)this);
    }

    @Override
    public void close() {
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)CHANNEL);
    }

    @Override
    protected void sendOutgoingMessage(byte[] buf) {
        AtomicReference<SchedulerTask> taskRef = new AtomicReference<SchedulerTask>();
        SchedulerTask task = this.plugin.getBootstrap().getScheduler().asyncRepeating(() -> {
            MinecraftServer server = this.plugin.getBootstrap().getServer().orElse(null);
            if (server == null) {
                return;
            }
            List players = server.method_3760().method_14571();
            class_3222 p = (class_3222)Iterables.getFirst((Iterable)players, null);
            if (p == null) {
                return;
            }
            ServerPlayNetworking.send((class_3222)p, (class_8710)new PluginMessagePayload(buf));
            SchedulerTask t = taskRef.getAndSet(null);
            if (t != null) {
                t.cancel();
            }
        }, 10L, TimeUnit.SECONDS);
        taskRef.set(task);
    }

    public void receive(PluginMessagePayload payload, ServerPlayNetworking.Context context) {
        this.handleIncomingMessage(payload.data);
    }

    static /* synthetic */ class_2960 access$100() {
        return CHANNEL;
    }

    public static class PluginMessagePayload
    implements class_8710 {
        public static final class_8710.class_9154<PluginMessagePayload> ID = new class_8710.class_9154(PluginMessageMessenger.access$100());
        public static final class_9139<class_9129, PluginMessagePayload> CODEC = class_9139.method_56438(PluginMessagePayload::write, PluginMessagePayload::new).method_56430();
        private final byte[] data;

        private PluginMessagePayload(byte[] data) {
            this.data = data;
        }

        private PluginMessagePayload(class_2540 buf) {
            this.data = new byte[buf.readableBytes()];
            buf.method_52979(this.data);
        }

        private void write(class_2540 buf) {
            buf.method_52983(this.data);
        }

        public class_8710.class_9154<PluginMessagePayload> method_56479() {
            return ID;
        }
    }
}

