/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.util.UUID;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.TranslatableComponent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;

public final class UniqueIdType {
    public static final UniqueIdType AUTHENTICATED = new UniqueIdType("authenticated", (TextColor)NamedTextColor.DARK_GREEN, "luckperms.command.user.info.uuid-type.mojang", "luckperms.command.user.info.uuid-type.desc.mojang");
    public static final UniqueIdType UNAUTHENTICATED = new UniqueIdType("unauthenticated", (TextColor)NamedTextColor.DARK_GRAY, "luckperms.command.user.info.uuid-type.not-mojang", "luckperms.command.user.info.uuid-type.desc.not-mojang");
    public static final UniqueIdType NPC = new UniqueIdType("npc", (TextColor)NamedTextColor.GOLD, "luckperms.command.user.info.uuid-type.npc", "luckperms.command.user.info.uuid-type.desc.npc");
    public static final UniqueIdType UNKNOWN = new UniqueIdType("unknown", (TextColor)NamedTextColor.RED, "luckperms.command.user.info.uuid-type.unknown", "luckperms.command.user.info.uuid-type.desc.unknown");
    private final String type;
    private final Component component;

    public static UniqueIdType determineType(UUID uniqueId, LuckPermsPlugin plugin) {
        String type;
        switch (uniqueId.version()) {
            case 4: {
                type = "authenticated";
                break;
            }
            case 3: {
                type = "unauthenticated";
                break;
            }
            case 2: {
                type = "npc";
                break;
            }
            default: {
                type = "unknown";
            }
        }
        switch (type = plugin.getEventDispatcher().dispatchUniqueIdDetermineType(uniqueId, type)) {
            case "authenticated": {
                return AUTHENTICATED;
            }
            case "unauthenticated": {
                return UNAUTHENTICATED;
            }
            case "npc": {
                return NPC;
            }
            case "unknown": {
                return UNKNOWN;
            }
        }
        return new UniqueIdType(type);
    }

    private UniqueIdType(String type, TextColor displayColor, String translationKey, String translationKeyHover) {
        this.type = type;
        this.component = ((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key(translationKey).color(displayColor)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.translatable((String)translationKeyHover, (TextColor)NamedTextColor.DARK_GRAY)))).build();
    }

    private UniqueIdType(String type) {
        this.type = type;
        this.component = ((TextComponent.Builder)((TextComponent.Builder)Component.text().content(type).color((TextColor)NamedTextColor.GOLD)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.translatable((String)"luckperms.command.user.info.uuid-type.desc.api", (TextColor)NamedTextColor.GRAY)))).build();
    }

    public String getType() {
        return this.type;
    }

    public Component describe() {
        return this.component;
    }
}

