/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.storage.StorageMetadata;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;
import me.lucko.luckperms.lib.hikari.HikariDataSource;

public abstract class HikariConnectionFactory
implements ConnectionFactory {
    private final StorageCredentials configuration;
    private HikariDataSource hikari;

    public HikariConnectionFactory(StorageCredentials configuration) {
        this.configuration = configuration;
    }

    protected abstract String defaultPort();

    protected abstract void configureDatabase(HikariConfig var1, String var2, String var3, String var4, String var5, String var6);

    protected void overrideProperties(Map<String, Object> properties) {
        properties.putIfAbsent("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    }

    protected void setProperties(HikariConfig config, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            config.addDataSourceProperty(property.getKey(), property.getValue());
        }
    }

    protected void postInitialize() {
    }

    @Override
    public void init(LuckPermsPlugin plugin) {
        HikariConfig config;
        try {
            config = new HikariConfig();
        }
        catch (LinkageError e) {
            HikariConnectionFactory.handleClassloadingError(e, plugin);
            throw e;
        }
        config.setPoolName("luckperms-hikari");
        String[] addressSplit = this.configuration.getAddress().split(":");
        String address = addressSplit[0];
        String port = addressSplit.length > 1 ? addressSplit[1] : this.defaultPort();
        try {
            this.configureDatabase(config, address, port, this.configuration.getDatabase(), this.configuration.getUsername(), this.configuration.getPassword());
        }
        catch (NoSuchMethodError e) {
            HikariConnectionFactory.handleClassloadingError(e, plugin);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(this.configuration.getProperties());
        this.overrideProperties(properties);
        this.setProperties(config, properties);
        config.setMaximumPoolSize(this.configuration.getMaxPoolSize());
        config.setMinimumIdle(this.configuration.getMinIdleConnections());
        config.setMaxLifetime((long)this.configuration.getMaxLifetime());
        config.setKeepaliveTime((long)this.configuration.getKeepAliveTime());
        config.setConnectionTimeout((long)this.configuration.getConnectionTimeout());
        config.setInitializationFailTimeout(-1L);
        this.hikari = new HikariDataSource(config);
        this.postInitialize();
    }

    @Override
    public void shutdown() {
        if (this.hikari != null) {
            this.hikari.close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.hikari == null) {
            throw new SQLException("Unable to get a connection from the pool. (hikari is null)");
        }
        Connection connection = this.hikari.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get a connection from the pool. (getConnection returned null)");
        }
        return connection;
    }

    @Override
    public StorageMetadata getMeta() {
        StorageMetadata metadata = new StorageMetadata();
        boolean success = true;
        long start = System.currentTimeMillis();
        try (Connection c = this.getConnection();
             Statement s = c.createStatement();){
            s.execute("/* ping */ SELECT 1");
        }
        catch (SQLException e) {
            success = false;
        }
        if (success) {
            int duration = (int)(System.currentTimeMillis() - start);
            metadata.ping(duration);
        }
        metadata.connected(success);
        return metadata;
    }

    private static void handleClassloadingError(Throwable throwable, LuckPermsPlugin plugin) {
        ImmutableList noteworthyClasses = ImmutableList.of((Object)"org.slf4j.LoggerFactory", (Object)"org.slf4j.ILoggerFactory", (Object)"org.apache.logging.slf4j.Log4jLoggerFactory", (Object)"org.apache.logging.log4j.spi.LoggerContext", (Object)"org.apache.logging.log4j.spi.AbstractLoggerAdapter", (Object)"org.slf4j.impl.StaticLoggerBinder", (Object)"org.slf4j.helpers.MessageFormatter");
        PluginLogger logger = plugin.getLogger();
        logger.warn("A " + throwable.getClass().getSimpleName() + " has occurred whilst initialising Hikari. This is likely due to classloading conflicts between other plugins.");
        logger.warn("Please check for other plugins below (and try loading LuckPerms without them installed) before reporting the issue.");
        for (String className : noteworthyClasses) {
            String loaderName;
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                continue;
            }
            ClassLoader loader = clazz.getClassLoader();
            try {
                loaderName = plugin.getBootstrap().identifyClassLoader(loader) + " (" + loader.toString() + ")";
            }
            catch (Throwable e) {
                loaderName = loader.toString();
            }
            logger.warn("Class " + className + " has been loaded by: " + loaderName);
        }
    }
}

