/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.HikariConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;

public abstract class DriverBasedHikariConnectionFactory
extends HikariConnectionFactory {
    protected DriverBasedHikariConnectionFactory(StorageCredentials configuration) {
        super(configuration);
    }

    protected abstract String driverClassName();

    protected abstract String driverJdbcIdentifier();

    @Override
    protected void configureDatabase(HikariConfig config, String address, String port, String databaseName, String username, String password) {
        config.setDriverClassName(this.driverClassName());
        config.setJdbcUrl(String.format("jdbc:%s://%s:%s/%s", this.driverJdbcIdentifier(), address, port, databaseName));
        config.setUsername(username);
        config.setPassword(password);
    }

    @Override
    protected void postInitialize() {
        super.postInitialize();
        DriverBasedHikariConnectionFactory.deregisterDriver(this.driverClassName());
    }

    private static void deregisterDriver(String driverClassName) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sQLException) {}
        }
    }
}

