/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageMetadata;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface StorageImplementation {
    public LuckPermsPlugin getPlugin();

    public String getImplementationName();

    public void init() throws Exception;

    public void shutdown();

    public StorageMetadata getMeta();

    public void logAction(Action var1) throws Exception;

    public Log getLog() throws Exception;

    public void applyBulkUpdate(BulkUpdate var1) throws Exception;

    public User loadUser(UUID var1, String var2) throws Exception;

    public Map<UUID, User> loadUsers(Set<UUID> var1) throws Exception;

    public void saveUser(User var1) throws Exception;

    public Set<UUID> getUniqueUsers() throws Exception;

    public <N extends Node> List<NodeEntry<UUID, N>> searchUserNodes(ConstraintNodeMatcher<N> var1) throws Exception;

    public Group createAndLoadGroup(String var1) throws Exception;

    public Optional<Group> loadGroup(String var1) throws Exception;

    public void loadAllGroups() throws Exception;

    public void saveGroup(Group var1) throws Exception;

    public void deleteGroup(Group var1) throws Exception;

    public <N extends Node> List<NodeEntry<String, N>> searchGroupNodes(ConstraintNodeMatcher<N> var1) throws Exception;

    public Track createAndLoadTrack(String var1) throws Exception;

    public Optional<Track> loadTrack(String var1) throws Exception;

    public void loadAllTracks() throws Exception;

    public void saveTrack(Track var1) throws Exception;

    public void deleteTrack(Track var1) throws Exception;

    public PlayerSaveResult savePlayerData(UUID var1, String var2) throws Exception;

    public void deletePlayerData(UUID var1) throws Exception;

    public @Nullable UUID getPlayerUniqueId(String var1) throws Exception;

    public @Nullable String getPlayerName(UUID var1) throws Exception;
}

