/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Locale;
import java.util.Map;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Weight
extends AbstractNode<WeightNode, WeightNode.Builder>
implements WeightNode {
    public static final String NODE_KEY = "weight";
    public static final String NODE_MARKER = "weight.";
    private final int weight;

    public static String key(int weight) {
        return NODE_MARKER + weight;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int weight) {
        return Weight.builder().weight(weight);
    }

    public Weight(int weight, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(Weight.key(weight), value, expireAt, contexts, metadata);
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.weight, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!key.toLowerCase(Locale.ROOT).startsWith(NODE_MARKER)) {
            return null;
        }
        try {
            return Weight.builder().weight(Integer.parseInt(key.substring(NODE_MARKER.length())));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final class Builder
    extends AbstractNodeBuilder<WeightNode, WeightNode.Builder>
    implements WeightNode.Builder {
        private Integer weight;

        private Builder() {
            this.weight = null;
        }

        public Builder(int weight, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.weight = weight;
        }

        @Override
        public @NonNull Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public @NonNull Weight build() {
            Builder.ensureDefined(this.weight, Weight.NODE_KEY);
            return new Weight(this.weight, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

