/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.redis;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.jedis.DefaultJedisClientConfig;
import me.lucko.luckperms.lib.jedis.HostAndPort;
import me.lucko.luckperms.lib.jedis.JedisClientConfig;
import me.lucko.luckperms.lib.jedis.JedisCluster;
import me.lucko.luckperms.lib.jedis.JedisPooled;
import me.lucko.luckperms.lib.jedis.JedisPubSub;
import me.lucko.luckperms.lib.jedis.UnifiedJedis;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RedisMessenger
implements Messenger {
    private static final String CHANNEL = "luckperms:update";
    private final LuckPermsPlugin plugin;
    private final IncomingMessageConsumer consumer;
    private UnifiedJedis jedis;
    private Subscription sub;
    private boolean closing = false;

    public RedisMessenger(LuckPermsPlugin plugin, IncomingMessageConsumer consumer) {
        this.plugin = plugin;
        this.consumer = consumer;
    }

    public void init(List<String> addresses, String username, String password, boolean ssl) {
        Set hosts = addresses.stream().map(RedisMessenger::parseAddress).collect(Collectors.toSet());
        this.init((UnifiedJedis)new JedisCluster(hosts, RedisMessenger.jedisConfig(username, password, ssl)));
    }

    public void init(String address, String username, String password, boolean ssl) {
        this.init((UnifiedJedis)new JedisPooled(RedisMessenger.parseAddress(address), RedisMessenger.jedisConfig(username, password, ssl)));
    }

    private void init(UnifiedJedis jedis) {
        this.jedis = jedis;
        this.sub = new Subscription(this);
        this.plugin.getBootstrap().getScheduler().executeAsync(this.sub);
    }

    private static JedisClientConfig jedisConfig(String username, String password, boolean ssl) {
        return DefaultJedisClientConfig.builder().user(username).password(password).ssl(ssl).timeoutMillis(2000).build();
    }

    private static HostAndPort parseAddress(String address) {
        String[] addressSplit = address.split(":");
        String host = addressSplit[0];
        int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 6379;
        return new HostAndPort(host, port);
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        this.jedis.publish(CHANNEL, outgoingMessage.asEncodedString());
    }

    @Override
    public void close() {
        this.closing = true;
        this.sub.unsubscribe();
        this.jedis.close();
    }

    private static class Subscription
    extends JedisPubSub
    implements Runnable {
        private final RedisMessenger messenger;

        private Subscription(RedisMessenger messenger) {
            this.messenger = messenger;
        }

        @Override
        public void run() {
            boolean first = true;
            while (!this.messenger.closing && !Thread.interrupted() && this.isRedisAlive()) {
                try {
                    if (first) {
                        first = false;
                    } else {
                        this.messenger.plugin.getLogger().info("Redis pubsub connection re-established");
                    }
                    this.messenger.jedis.subscribe((JedisPubSub)this, new String[]{RedisMessenger.CHANNEL});
                }
                catch (Exception e) {
                    if (this.messenger.closing) {
                        return;
                    }
                    this.messenger.plugin.getLogger().warn("Redis pubsub connection dropped, trying to re-open the connection", e);
                    try {
                        this.unsubscribe();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void onMessage(String channel, String msg) {
            if (!channel.equals(RedisMessenger.CHANNEL)) {
                return;
            }
            this.messenger.consumer.consumeIncomingMessageAsString(msg);
        }

        private boolean isRedisAlive() {
            UnifiedJedis jedis = this.messenger.jedis;
            if (jedis instanceof JedisPooled) {
                return !((JedisPooled)jedis).getPool().isClosed();
            }
            if (jedis instanceof JedisCluster) {
                return !((JedisCluster)jedis).getClusterNodes().isEmpty();
            }
            throw new RuntimeException("Unknown jedis type: " + jedis.getClass().getName());
        }
    }
}

