/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.message;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import me.lucko.luckperms.common.messaging.LuckPermsMessagingService;
import me.lucko.luckperms.common.messaging.message.AbstractMessage;
import me.lucko.luckperms.common.util.gson.JObject;
import net.luckperms.api.messenger.message.type.CustomMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CustomMessageImpl
extends AbstractMessage
implements CustomMessage {
    public static final String TYPE = "custom";
    private final String channelId;
    private final String payload;

    public static CustomMessageImpl decode(@Nullable JsonElement content, UUID id) {
        if (content == null) {
            throw new IllegalStateException("Missing content");
        }
        JsonObject obj = content.getAsJsonObject();
        if (!obj.has("channelId")) {
            throw new IllegalStateException("Incoming message has no 'channelId' argument: " + content);
        }
        if (!obj.has("payload")) {
            throw new IllegalStateException("Incoming message has no 'payload' argument: " + content);
        }
        String channelId = obj.get("channelId").getAsString();
        String payload = obj.get("payload").getAsString();
        return new CustomMessageImpl(id, channelId, payload);
    }

    public CustomMessageImpl(UUID id, String channelId, String payload) {
        super(id);
        this.channelId = channelId;
        this.payload = payload;
    }

    @Override
    public @NonNull String getChannelId() {
        return this.channelId;
    }

    @Override
    public @NonNull String getPayload() {
        return this.payload;
    }

    @Override
    public @NonNull String asEncodedString() {
        return LuckPermsMessagingService.encodeMessageAsString(TYPE, this.getId(), (JsonElement)new JObject().add("channelId", this.channelId).add("payload", this.payload).toJson());
    }
}

