/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.common.api.implementation.ApiPermissionHolder;
import me.lucko.luckperms.common.cacheddata.GroupCachedDataManager;
import me.lucko.luckperms.common.cacheddata.UserCachedDataManager;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.event.gen.GeneratedEventClass;
import me.lucko.luckperms.common.event.model.EntitySourceImpl;
import me.lucko.luckperms.common.event.model.SenderPlatformEntity;
import me.lucko.luckperms.common.event.model.UnknownSource;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Difference;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.LuckPermsEvent;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.event.cause.DeletionCause;
import net.luckperms.api.event.context.ContextUpdateEvent;
import net.luckperms.api.event.extension.ExtensionLoadEvent;
import net.luckperms.api.event.group.GroupCacheLoadEvent;
import net.luckperms.api.event.group.GroupCreateEvent;
import net.luckperms.api.event.group.GroupDataRecalculateEvent;
import net.luckperms.api.event.group.GroupDeleteEvent;
import net.luckperms.api.event.group.GroupLoadAllEvent;
import net.luckperms.api.event.group.GroupLoadEvent;
import net.luckperms.api.event.log.LogBroadcastEvent;
import net.luckperms.api.event.log.LogNetworkPublishEvent;
import net.luckperms.api.event.log.LogNotifyEvent;
import net.luckperms.api.event.log.LogPublishEvent;
import net.luckperms.api.event.log.LogReceiveEvent;
import net.luckperms.api.event.messaging.CustomMessageReceiveEvent;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.event.player.PlayerDataSaveEvent;
import net.luckperms.api.event.player.PlayerLoginProcessEvent;
import net.luckperms.api.event.player.lookup.UniqueIdDetermineTypeEvent;
import net.luckperms.api.event.player.lookup.UniqueIdLookupEvent;
import net.luckperms.api.event.player.lookup.UsernameLookupEvent;
import net.luckperms.api.event.player.lookup.UsernameValidityCheckEvent;
import net.luckperms.api.event.source.Source;
import net.luckperms.api.event.sync.ConfigReloadEvent;
import net.luckperms.api.event.sync.PostNetworkSyncEvent;
import net.luckperms.api.event.sync.PostSyncEvent;
import net.luckperms.api.event.sync.PreNetworkSyncEvent;
import net.luckperms.api.event.sync.PreSyncEvent;
import net.luckperms.api.event.sync.SyncType;
import net.luckperms.api.event.track.TrackCreateEvent;
import net.luckperms.api.event.track.TrackDeleteEvent;
import net.luckperms.api.event.track.TrackLoadAllEvent;
import net.luckperms.api.event.track.TrackLoadEvent;
import net.luckperms.api.event.track.mutate.TrackAddGroupEvent;
import net.luckperms.api.event.track.mutate.TrackClearEvent;
import net.luckperms.api.event.track.mutate.TrackRemoveGroupEvent;
import net.luckperms.api.event.type.Cancellable;
import net.luckperms.api.event.type.ResultEvent;
import net.luckperms.api.event.user.UserCacheLoadEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.event.user.UserFirstLoginEvent;
import net.luckperms.api.event.user.UserLoadEvent;
import net.luckperms.api.event.user.UserUnloadEvent;
import net.luckperms.api.event.user.track.UserDemoteEvent;
import net.luckperms.api.event.user.track.UserPromoteEvent;
import net.luckperms.api.extension.Extension;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EventDispatcher {
    private final AbstractEventBus<?> eventBus;

    public EventDispatcher(AbstractEventBus<?> eventBus) {
        this.eventBus = eventBus;
    }

    public AbstractEventBus<?> getEventBus() {
        return this.eventBus;
    }

    private LuckPermsEvent generate(Class<? extends LuckPermsEvent> eventClass, Object ... params) {
        try {
            return GeneratedEventClass.generate(eventClass).newInstance(this.eventBus.getApiProvider(), params);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception occurred whilst generating event instance", e);
        }
    }

    private void post(Class<? extends LuckPermsEvent> eventClass, Object ... params) {
        LuckPermsEvent event = this.generate(eventClass, params);
        this.eventBus.post(event);
    }

    private void postAsync(Class<? extends LuckPermsEvent> eventClass, Object ... params) {
        if (Cancellable.class.isAssignableFrom(eventClass) || ResultEvent.class.isAssignableFrom(eventClass)) {
            throw new RuntimeException("Event cannot be posted async (" + eventClass.getName() + ")");
        }
        if (!this.eventBus.shouldPost(eventClass)) {
            return;
        }
        this.eventBus.getPlugin().getBootstrap().getScheduler().executeAsync(() -> this.post(eventClass, params));
    }

    private void postSync(Class<? extends LuckPermsEvent> eventClass, Object ... params) {
        if (!this.eventBus.shouldPost(eventClass)) {
            return;
        }
        this.post(eventClass, params);
    }

    private boolean postCancellable(Class<? extends LuckPermsEvent> eventClass, Object ... params) {
        if (!Cancellable.class.isAssignableFrom(eventClass)) {
            throw new RuntimeException("Event is not cancellable: " + eventClass.getName());
        }
        boolean initialState = (Boolean)params[0];
        if (!this.eventBus.shouldPost(eventClass)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        params[0] = cancel;
        this.post(eventClass, params);
        return cancel.get();
    }

    public void dispatchContextUpdate(Object subject) {
        this.postSync(ContextUpdateEvent.class, subject);
    }

    public void dispatchExtensionLoad(Extension extension) {
        this.postAsync(ExtensionLoadEvent.class, extension);
    }

    public void dispatchGroupCacheLoad(Group group, GroupCachedDataManager data) {
        this.postAsync(GroupCacheLoadEvent.class, group.getApiProxy(), data);
    }

    public void dispatchGroupCreate(Group group, CreationCause cause) {
        this.postAsync(GroupCreateEvent.class, new Object[]{group.getApiProxy(), cause});
    }

    public void dispatchGroupDelete(Group group, DeletionCause cause) {
        this.postAsync(GroupDeleteEvent.class, new Object[]{group.getName(), ImmutableSet.copyOf(group.normalData().asSet()), cause});
    }

    public void dispatchGroupLoadAll() {
        this.postAsync(GroupLoadAllEvent.class, new Object[0]);
    }

    public void dispatchGroupLoad(Group group) {
        this.postAsync(GroupLoadEvent.class, group.getApiProxy());
    }

    public boolean dispatchLogBroadcast(boolean initialState, Action entry, LogBroadcastEvent.Origin origin) {
        return this.postCancellable(LogBroadcastEvent.class, new Object[]{initialState, entry, origin});
    }

    public boolean dispatchLogPublish(boolean initialState, Action entry) {
        return this.postCancellable(LogPublishEvent.class, initialState, entry);
    }

    public boolean dispatchLogNetworkPublish(boolean initialState, UUID id, Action entry) {
        return this.postCancellable(LogNetworkPublishEvent.class, initialState, id, entry);
    }

    public boolean dispatchLogNotify(boolean initialState, Action entry, LogNotifyEvent.Origin origin, Sender sender) {
        return this.postCancellable(LogNotifyEvent.class, new Object[]{initialState, entry, origin, new SenderPlatformEntity(sender)});
    }

    public void dispatchLogReceive(UUID id, Action entry) {
        this.postAsync(LogReceiveEvent.class, id, entry);
    }

    public void dispatchCustomMessageReceive(String channelId, String payload) {
        this.postAsync(CustomMessageReceiveEvent.class, channelId, payload);
    }

    public void dispatchNodeChanges(PermissionHolder target, DataType dataType, Difference<Node> changes) {
        if (!this.eventBus.shouldPost(NodeAddEvent.class) && !this.eventBus.shouldPost(NodeRemoveEvent.class)) {
            return;
        }
        if (changes.isEmpty()) {
            return;
        }
        ApiPermissionHolder proxy = EventDispatcher.proxy(target);
        ImmutableSet<Node> state = target.getData(dataType).asImmutableSet();
        for (Difference.Change<Node> change : changes.getChanges()) {
            Class type = change.type() == Difference.ChangeType.ADD ? NodeAddEvent.class : NodeRemoveEvent.class;
            this.postAsync(type, new Object[]{proxy, dataType, state, change.value()});
        }
    }

    public void dispatchNodeClear(PermissionHolder target, DataType dataType, Difference<Node> changes) {
        if (!this.eventBus.shouldPost(NodeClearEvent.class)) {
            return;
        }
        if (changes.isEmpty()) {
            return;
        }
        ApiPermissionHolder proxy = EventDispatcher.proxy(target);
        ImmutableSet<Node> state = target.getData(dataType).asImmutableSet();
        ImmutableSet nodes = ImmutableSet.copyOf(changes.getRemoved());
        this.postAsync(NodeClearEvent.class, new Object[]{proxy, dataType, state, nodes});
        for (Node added : changes.getAdded()) {
            this.postAsync(NodeAddEvent.class, new Object[]{proxy, dataType, state, added});
        }
    }

    public void dispatchConfigReload() {
        this.postAsync(ConfigReloadEvent.class, new Object[0]);
    }

    public void dispatchNetworkPostSync(UUID id, SyncType type, boolean didOccur, UUID specificUserUniqueId) {
        this.postAsync(PostNetworkSyncEvent.class, new Object[]{id, type, didOccur, specificUserUniqueId});
    }

    public void dispatchPostSync() {
        this.postAsync(PostSyncEvent.class, new Object[0]);
    }

    public boolean dispatchNetworkPreSync(boolean initialState, UUID id, SyncType type, UUID specificUserUniqueId) {
        return this.postCancellable(PreNetworkSyncEvent.class, new Object[]{initialState, id, type, specificUserUniqueId});
    }

    public boolean dispatchPreSync(boolean initialState) {
        return this.postCancellable(PreSyncEvent.class, initialState);
    }

    public void dispatchTrackCreate(Track track, CreationCause cause) {
        this.postAsync(TrackCreateEvent.class, new Object[]{track.getApiProxy(), cause});
    }

    public void dispatchTrackDelete(Track track, DeletionCause cause) {
        this.postAsync(TrackDeleteEvent.class, new Object[]{track.getName(), ImmutableList.copyOf(track.getGroups()), cause});
    }

    public void dispatchTrackLoadAll() {
        this.postAsync(TrackLoadAllEvent.class, new Object[0]);
    }

    public void dispatchTrackLoad(Track track) {
        this.postAsync(TrackLoadEvent.class, track.getApiProxy());
    }

    public void dispatchTrackAddGroup(Track track, String group, List<String> before, List<String> after) {
        this.postAsync(TrackAddGroupEvent.class, track.getApiProxy(), ImmutableList.copyOf(before), ImmutableList.copyOf(after), group);
    }

    public void dispatchTrackClear(Track track, List<String> before) {
        this.postAsync(TrackClearEvent.class, track.getApiProxy(), ImmutableList.copyOf(before), ImmutableList.of());
    }

    public void dispatchTrackRemoveGroup(Track track, String group, List<String> before, List<String> after) {
        this.postAsync(TrackRemoveGroupEvent.class, track.getApiProxy(), ImmutableList.copyOf(before), ImmutableList.copyOf(after), group);
    }

    public void dispatchUserCacheLoad(User user, UserCachedDataManager data) {
        this.postAsync(UserCacheLoadEvent.class, user.getApiProxy(), data);
    }

    public void dispatchDataRecalculate(PermissionHolder holder) {
        if (holder.getType() == HolderType.USER) {
            User user = (User)holder;
            this.postAsync(UserDataRecalculateEvent.class, user.getApiProxy(), user.getCachedData());
        } else {
            Group group = (Group)holder;
            this.postAsync(GroupDataRecalculateEvent.class, group.getApiProxy(), group.getCachedData());
        }
    }

    public void dispatchUserFirstLogin(UUID uniqueId, String username) {
        this.postAsync(UserFirstLoginEvent.class, uniqueId, username);
    }

    public void dispatchPlayerLoginProcess(UUID uniqueId, String username, @Nullable User user) {
        this.postSync(PlayerLoginProcessEvent.class, uniqueId, username, user == null ? null : user.getApiProxy());
    }

    public void dispatchPlayerDataSave(UUID uniqueId, String username, PlayerSaveResult result) {
        this.postAsync(PlayerDataSaveEvent.class, uniqueId, username, result);
    }

    public String dispatchUniqueIdDetermineType(UUID uniqueId, String initialType) {
        AtomicReference<String> result = new AtomicReference<String>(initialType);
        this.postSync(UniqueIdDetermineTypeEvent.class, result, uniqueId);
        return result.get();
    }

    public UUID dispatchUniqueIdLookup(String username, UUID initial) {
        AtomicReference<UUID> result = new AtomicReference<UUID>(initial);
        this.postSync(UniqueIdLookupEvent.class, result, username);
        return result.get();
    }

    public String dispatchUsernameLookup(UUID uniqueId, String initial) {
        AtomicReference<String> result = new AtomicReference<String>(initial);
        this.postSync(UsernameLookupEvent.class, result, uniqueId);
        return result.get();
    }

    public boolean dispatchUsernameValidityCheck(String username, boolean initialState) {
        AtomicBoolean result = new AtomicBoolean(initialState);
        this.postSync(UsernameValidityCheckEvent.class, username, result);
        return result.get();
    }

    public void dispatchUserLoad(User user) {
        this.postAsync(UserLoadEvent.class, user.getApiProxy());
    }

    public boolean dispatchUserUnload(User user) {
        return this.postCancellable(UserUnloadEvent.class, false, user.getApiProxy());
    }

    public void dispatchUserDemote(User user, Track track, String from, String to, @Nullable Sender sender) {
        Source source = sender == null ? UnknownSource.INSTANCE : new EntitySourceImpl(new SenderPlatformEntity(sender));
        this.postAsync(UserDemoteEvent.class, source, track.getApiProxy(), user.getApiProxy(), Optional.ofNullable(from), Optional.ofNullable(to));
    }

    public void dispatchUserPromote(User user, Track track, String from, String to, @Nullable Sender sender) {
        Source source = sender == null ? UnknownSource.INSTANCE : new EntitySourceImpl(new SenderPlatformEntity(sender));
        this.postAsync(UserPromoteEvent.class, source, track.getApiProxy(), user.getApiProxy(), Optional.ofNullable(from), Optional.ofNullable(to));
    }

    private static ApiPermissionHolder proxy(PermissionHolder holder) {
        if (holder instanceof Group) {
            return ((Group)holder).getApiProxy();
        }
        if (holder instanceof User) {
            return ((User)holder).getApiProxy();
        }
        throw new AssertionError();
    }

    public static Class<? extends LuckPermsEvent>[] getKnownEventTypes() {
        return new Class[]{ContextUpdateEvent.class, ExtensionLoadEvent.class, GroupCacheLoadEvent.class, GroupCreateEvent.class, GroupDataRecalculateEvent.class, GroupDeleteEvent.class, GroupLoadAllEvent.class, GroupLoadEvent.class, LogBroadcastEvent.class, LogNetworkPublishEvent.class, LogNotifyEvent.class, LogPublishEvent.class, LogReceiveEvent.class, CustomMessageReceiveEvent.class, NodeAddEvent.class, NodeClearEvent.class, NodeRemoveEvent.class, PlayerDataSaveEvent.class, PlayerLoginProcessEvent.class, UniqueIdDetermineTypeEvent.class, UniqueIdLookupEvent.class, UsernameLookupEvent.class, UsernameValidityCheckEvent.class, ConfigReloadEvent.class, PostNetworkSyncEvent.class, PostSyncEvent.class, PreNetworkSyncEvent.class, PreSyncEvent.class, TrackCreateEvent.class, TrackDeleteEvent.class, TrackLoadAllEvent.class, TrackLoadEvent.class, TrackAddGroupEvent.class, TrackClearEvent.class, TrackRemoveGroupEvent.class, UserCacheLoadEvent.class, UserDataRecalculateEvent.class, UserFirstLoginEvent.class, UserLoadEvent.class, UserUnloadEvent.class, UserDemoteEvent.class, UserPromoteEvent.class};
    }
}

