/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.generic;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.common.config.generic.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.config.generic.key.ConfigKey;
import me.lucko.luckperms.common.config.generic.key.SimpleConfigKey;
import me.lucko.luckperms.common.util.ImmutableCollectors;

public class KeyedConfiguration {
    private final ConfigurationAdapter adapter;
    private final List<? extends ConfigKey<?>> keys;
    private final ValuesMap values;

    public KeyedConfiguration(ConfigurationAdapter adapter, List<? extends ConfigKey<?>> keys) {
        this.adapter = adapter;
        this.keys = keys;
        this.values = new ValuesMap(keys.size());
    }

    protected void init() {
        this.load(true);
    }

    public <T> T get(ConfigKey<T> key) {
        return this.values.get(key);
    }

    protected void load(boolean initial) {
        for (ConfigKey<?> key : this.keys) {
            if (!initial && !key.reloadable()) continue;
            this.values.put(key, key.get(this.adapter));
        }
    }

    public void reload() {
        this.adapter.reload();
        this.load(false);
    }

    public static List<SimpleConfigKey<?>> initialise(Class<?> keysClass) {
        List keys = (List)Arrays.stream(keysClass.getFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> ConfigKey.class.equals(f.getType())).map(f -> {
            try {
                return (SimpleConfigKey)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(ImmutableCollectors.toList());
        for (int i = 0; i < keys.size(); ++i) {
            ((SimpleConfigKey)keys.get(i)).setOrdinal(i);
        }
        return keys;
    }

    public static class ValuesMap {
        private final Object[] values;

        public ValuesMap(int size) {
            this.values = new Object[size];
        }

        public <T> T get(ConfigKey<T> key) {
            return (T)this.values[key.ordinal()];
        }

        public void put(ConfigKey<?> key, Object value) {
            this.values[key.ordinal()] = value;
        }
    }
}

