/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.node.types.Weight;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;

public class GroupSetWeight
extends ChildCommand<Group> {
    public GroupSetWeight() {
        super(CommandSpec.GROUP_SETWEIGHT, "setweight", CommandPermission.GROUP_SET_WEIGHT, Predicates.not(1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Group target, ArgumentList args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        int weight = args.getPriority(0);
        target.removeIf(DataType.NORMAL, null, NodeType.WEIGHT::matches, false);
        target.setNode(DataType.NORMAL, (Node)Weight.builder(weight).build(), true);
        Message.GROUP_SET_WEIGHT.send(sender, weight, target);
        LoggedAction.build().source(sender).target(target).description("setweight", weight).build().submit(plugin, sender);
        StorageAssistant.save(target, sender, plugin);
    }
}

