/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.Argument;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;

public abstract class GenericChildCommand {
    private final CommandSpec spec;
    private final String name;
    private final CommandPermission userPermission;
    private final CommandPermission groupPermission;
    private final Predicate<? super Integer> argumentCheck;

    public GenericChildCommand(CommandSpec spec, String name, CommandPermission userPermission, CommandPermission groupPermission, Predicate<? super Integer> argumentCheck) {
        this.spec = spec;
        this.name = name;
        this.userPermission = userPermission;
        this.groupPermission = groupPermission;
        this.argumentCheck = argumentCheck;
    }

    public abstract void execute(LuckPermsPlugin var1, Sender var2, PermissionHolder var3, ArgumentList var4, String var5, CommandPermission var6) throws CommandException;

    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return Collections.emptyList();
    }

    public CommandSpec getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.name;
    }

    public CommandPermission getUserPermission() {
        return this.userPermission;
    }

    public CommandPermission getGroupPermission() {
        return this.groupPermission;
    }

    public Predicate<? super Integer> getArgumentCheck() {
        return this.argumentCheck;
    }

    public void sendUsage(Sender sender) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)this.getName().toLowerCase(Locale.ROOT), (TextColor)NamedTextColor.GREEN));
        if (this.getArgs() != null) {
            List argUsages = this.getArgs().stream().map(Argument::asPrettyString).collect(Collectors.toList());
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.join((ComponentLike)Component.space(), argUsages))).build();
        }
        sender.sendMessage((Component)builder.build());
    }

    public void sendDetailedUsage(Sender sender) {
        Message.COMMAND_USAGE_DETAILED_HEADER.send(sender, this.getName(), this.getDescription());
        if (this.getArgs() != null) {
            Message.COMMAND_USAGE_DETAILED_ARGS_HEADER.send(sender);
            for (Argument arg : this.getArgs()) {
                Message.COMMAND_USAGE_DETAILED_ARG.send(sender, arg.asPrettyString(), (Component)arg.getDescription());
            }
        }
    }

    public boolean isAuthorized(Sender sender, HolderType type) {
        switch (type) {
            case USER: {
                return this.userPermission.isAuthorized(sender);
            }
            case GROUP: {
                return this.groupPermission.isAuthorized(sender);
            }
        }
        throw new AssertionError((Object)type);
    }

    public Component getDescription() {
        return this.spec.description();
    }

    public List<Argument> getArgs() {
        return this.spec.args();
    }
}

