/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.implementation.ApiAbstractManager;
import me.lucko.luckperms.common.api.implementation.ApiTrack;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.event.cause.DeletionCause;
import net.luckperms.api.track.Track;
import net.luckperms.api.track.TrackManager;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiTrackManager
extends ApiAbstractManager<me.lucko.luckperms.common.model.Track, Track, me.lucko.luckperms.common.model.manager.track.TrackManager<?>>
implements TrackManager {
    public ApiTrackManager(LuckPermsPlugin plugin, me.lucko.luckperms.common.model.manager.track.TrackManager<?> handle) {
        super(plugin, handle);
    }

    @Override
    protected Track proxy(me.lucko.luckperms.common.model.Track internal) {
        return internal == null ? null : internal.getApiProxy();
    }

    @Override
    public @NonNull CompletableFuture<Track> createAndLoadTrack(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().createAndLoadTrack(name, CreationCause.API).thenApply(this::proxy);
    }

    @Override
    public @NonNull CompletableFuture<Optional<Track>> loadTrack(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().loadTrack(name).thenApply(opt -> opt.map(this::proxy));
    }

    @Override
    public @NonNull CompletableFuture<Void> saveTrack(@NonNull Track track) {
        Objects.requireNonNull(track, "track");
        return this.plugin.getStorage().saveTrack(ApiTrack.cast(track));
    }

    @Override
    public @NonNull CompletableFuture<Void> deleteTrack(@NonNull Track track) {
        Objects.requireNonNull(track, "track");
        return this.plugin.getStorage().deleteTrack(ApiTrack.cast(track), DeletionCause.API);
    }

    @Override
    public @NonNull CompletableFuture<Void> modifyTrack(@NonNull String name, @NonNull Consumer<? super Track> action) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(action, "action");
        return ((CompletableFuture)this.plugin.getStorage().createAndLoadTrack(name, CreationCause.API).thenApplyAsync(track -> {
            action.accept(track.getApiProxy());
            return track;
        }, this.plugin.getBootstrap().getScheduler().async())).thenCompose(track -> this.plugin.getStorage().saveTrack((me.lucko.luckperms.common.model.Track)track));
    }

    @Override
    public @NonNull CompletableFuture<Void> loadAllTracks() {
        return this.plugin.getStorage().loadAllTracks();
    }

    @Override
    public Track getTrack(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.proxy((me.lucko.luckperms.common.model.Track)((me.lucko.luckperms.common.model.manager.track.TrackManager)this.handle).getIfLoaded(name));
    }

    @Override
    public @NonNull Set<Track> getLoadedTracks() {
        return (Set)((me.lucko.luckperms.common.model.manager.track.TrackManager)this.handle).getAll().values().stream().map(this::proxy).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isLoaded(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((me.lucko.luckperms.common.model.manager.track.TrackManager)this.handle).isLoaded(name);
    }
}

