/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_1068;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.auth.LoginData;
import ru.vidtu.ias.config.IASStorage;
import ru.vidtu.ias.screen.AccountEntry;
import ru.vidtu.ias.screen.AccountScreen;
import ru.vidtu.ias.screen.AddPopupScreen;
import ru.vidtu.ias.screen.DeletePopupScreen;
import ru.vidtu.ias.screen.LoginPopupScreen;

final class AccountList
extends class_4280<AccountEntry> {
    private static final Map<UUID, class_8685> SKINS = new WeakHashMap<UUID, class_8685>(4);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/AccountList");
    private final AccountScreen screen;

    AccountList(AccountScreen screen, class_310 minecraft, int width, int height, int offset, int item) {
        super(minecraft, width, height, offset, item);
        this.screen = screen;
        this.update(this.screen.search().method_1882());
    }

    public int method_25322() {
        return Math.min(super.method_25322(), this.screen.field_22789 - 190);
    }

    public void setSelected(@Nullable AccountEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.updateSelected();
    }

    void update(String query) {
        if (query == null || query.isBlank()) {
            AccountEntry selected = (AccountEntry)this.method_25334();
            this.method_25314(IASStorage.accounts.stream().map(account -> new AccountEntry(this.field_22740, this, (Account)account)).toList());
            this.setSelected(this.method_25396().contains((Object)selected) ? selected : null);
            this.screen.updateSelected();
            return;
        }
        String lowerQuery = query.toLowerCase(Locale.ROOT);
        AccountEntry selected = (AccountEntry)this.method_25334();
        this.method_25314(IASStorage.accounts.stream().filter(account -> account.name().toLowerCase(Locale.ROOT).contains(lowerQuery)).sorted((f, s) -> Boolean.compare(s.name().toLowerCase(Locale.ROOT).startsWith(lowerQuery), f.name().toLowerCase(Locale.ROOT).startsWith(lowerQuery))).map(account -> new AccountEntry(this.field_22740, this, (Account)account)).toList());
        this.setSelected(this.method_25396().contains((Object)selected) ? selected : null);
        this.screen.updateSelected();
    }

    void login(boolean online) {
        AccountEntry selected = (AccountEntry)this.method_25334();
        if (selected == null) {
            return;
        }
        Account account = selected.account();
        if (online && account.canLogin()) {
            LoginPopupScreen login = new LoginPopupScreen(this.screen);
            this.field_22740.method_1507((class_437)login);
            IAS.executor().execute(() -> account.login(login));
            return;
        }
        LoginPopupScreen login = new LoginPopupScreen(this.screen);
        this.field_22740.method_1507((class_437)login);
        String name = account.name();
        LoginData data = new LoginData(name, OfflineAccount.uuid(name), "ias:offline", false);
        login.success(data, false);
    }

    void edit() {
        AccountEntry selected = (AccountEntry)this.method_25334();
        if (selected == null) {
            return;
        }
        int index = this.method_25396().indexOf((Object)selected);
        if (index < 0 || index >= IASStorage.accounts.size()) {
            return;
        }
        this.field_22740.method_1507((class_437)new AddPopupScreen(this.screen, true, account -> {
            this.field_22740.method_1507((class_437)this.screen);
            IASStorage.accounts.removeIf(Predicate.isEqual(account));
            if (index >= IASStorage.accounts.size()) {
                IASStorage.accounts.add((Account)account);
            } else {
                IASStorage.accounts.set(index, (Account)account);
            }
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().method_1882());
        }));
    }

    void delete(boolean confirm) {
        AccountEntry selected = (AccountEntry)this.method_25334();
        if (selected == null) {
            return;
        }
        Account account = selected.account();
        if (!confirm) {
            IASStorage.accounts.remove(account);
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().method_1882());
            return;
        }
        this.field_22740.method_1507((class_437)new DeletePopupScreen(this.screen, account, () -> {
            IASStorage.accounts.removeIf(Predicate.isEqual(account));
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().method_1882());
        }));
    }

    void add() {
        this.field_22740.method_1507((class_437)new AddPopupScreen(this.screen, false, account -> {
            this.field_22740.method_1507((class_437)this.screen);
            IASStorage.accounts.removeIf(Predicate.isEqual(account));
            IASStorage.accounts.add((Account)account);
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().method_1882());
        }));
    }

    class_8685 skin(AccountEntry entry) {
        UUID uuid = entry.account().uuid();
        class_8685 skin = SKINS.get(uuid);
        if (skin != null) {
            return skin;
        }
        skin = class_1068.method_4648((UUID)uuid);
        SKINS.put(uuid, skin);
        if (uuid.version() != 4) {
            return skin;
        }
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            ProfileResult result = this.field_22740.method_1495().fetchProfile(uuid, false);
            if (result == null) {
                return null;
            }
            return result.profile();
        }, IAS.executor()).thenComposeAsync(profile -> {
            if (profile == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.field_22740.method_1582().method_52863(profile);
        }, (Executor)IAS.executor())).thenAcceptAsync(loaded -> {
            if (loaded == null) {
                return;
            }
            SKINS.put(uuid, (class_8685)loaded);
        }, (Executor)this.field_22740)).exceptionally(t -> {
            LOGGER.warn("IAS: Unable to load skin: {}", (Object)entry, t);
            return null;
        });
        return skin;
    }

    void swapUp(AccountEntry entry) {
        int idx = this.method_25396().indexOf((Object)entry);
        if (idx < 0 || idx >= IASStorage.accounts.size()) {
            return;
        }
        int upIdx = idx - 1;
        if (upIdx < 0) {
            return;
        }
        IASStorage.accounts.set(idx, IASStorage.accounts.get(upIdx));
        IASStorage.accounts.set(upIdx, entry.account());
        try {
            IAS.disclaimersStorage();
            IAS.saveStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save storage.", t);
        }
        this.method_25396().set(idx, (AccountEntry)((Object)this.method_25396().get(upIdx)));
        this.method_25396().set(upIdx, entry);
        this.setSelected(entry);
    }

    void swapDown(AccountEntry entry) {
        int idx = this.method_25396().indexOf((Object)entry);
        if (idx < 0 || idx >= IASStorage.accounts.size()) {
            return;
        }
        int downIdx = idx + 1;
        if (downIdx >= this.method_25396().size() || downIdx >= IASStorage.accounts.size()) {
            return;
        }
        IASStorage.accounts.set(idx, IASStorage.accounts.get(downIdx));
        IASStorage.accounts.set(downIdx, entry.account());
        try {
            IAS.disclaimersStorage();
            IAS.saveStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save storage.", t);
        }
        this.method_25396().set(idx, (AccountEntry)((Object)this.method_25396().get(downIdx)));
        this.method_25396().set(downIdx, entry);
        this.setSelected(entry);
    }

    AccountScreen screen() {
        return this.screen;
    }

    public String toString() {
        return "AccountList{children=" + String.valueOf(this.method_25396()) + "}";
    }
}

