/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.account;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.auth.handlers.LoginHandler;

public final class OfflineAccount
implements Account {
    private final String name;
    private final UUID uuid;

    public OfflineAccount(String name) {
        this.name = name;
        this.uuid = OfflineAccount.uuid(name);
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return "ias:offline_v1";
    }

    @Override
    public String typeTipKey() {
        return "ias.accounts.tip.type.offline";
    }

    @Override
    public boolean canLogin() {
        return false;
    }

    @Override
    public boolean insecure() {
        return false;
    }

    @Override
    public void login(LoginHandler handler) {
        handler.error(new UnsupportedOperationException("Offline account login: " + String.valueOf(this)));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OfflineAccount)) {
            return false;
        }
        OfflineAccount that = (OfflineAccount)obj;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "OfflineAccount{name='" + this.name + "', uuid=" + String.valueOf(this.uuid) + "}";
    }

    public static OfflineAccount read(DataInput in) throws IOException {
        String name = in.readUTF();
        return new OfflineAccount(name);
    }

    public static UUID uuid(String name) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
    }
}

