/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3419;
import net.minecraft.class_3898;
import net.minecraft.class_3902;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_6836;
import net.minecraft.class_6841;
import net.minecraft.class_6843;
import net.minecraft.class_7924;
import org.popcraft.chunky.mixin.ServerChunkManagerMixin;
import org.popcraft.chunky.mixin.ThreadedAnvilChunkStorageMixin;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.FabricBorder;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Input;

public class FabricWorld
implements World {
    private static final int TICKING_LOAD_DURATION = Input.tryInteger(System.getProperty("chunky.tickingLoadDuration")).orElse(0);
    private static final class_3230<class_3902> CHUNKY = class_3230.method_14291((String)"chunky", (unit, unit2) -> 0);
    private static final class_3230<class_3902> CHUNKY_TICKING = class_3230.method_20628((String)"chunky_ticking", (unit, unit2) -> 0, (int)(TICKING_LOAD_DURATION * 20));
    private static final boolean UPDATE_CHUNK_NBT = Boolean.getBoolean("chunky.updateChunkNbt");
    private final class_3218 serverWorld;
    private final Border worldBorder;

    public FabricWorld(class_3218 serverWorld) {
        this.serverWorld = serverWorld;
        this.worldBorder = new FabricBorder(serverWorld.method_8621());
    }

    @Override
    public String getName() {
        return this.serverWorld.method_27983().method_29177().toString();
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public CompletableFuture<Boolean> isChunkGenerated(int x, int z) {
        if (Thread.currentThread() != this.serverWorld.method_8503().method_3777()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), (Executor)this.serverWorld.method_8503()).join();
        }
        class_1923 chunkPos = new class_1923(x, z);
        class_3215 serverChunkManager = this.serverWorld.method_14178();
        class_3898 chunkStorage = serverChunkManager.field_17254;
        ThreadedAnvilChunkStorageMixin chunkStorageMixin = (ThreadedAnvilChunkStorageMixin)chunkStorage;
        class_3193 loadedChunkHolder = chunkStorageMixin.invokeGetChunkHolder(chunkPos.method_8324());
        if (loadedChunkHolder != null && loadedChunkHolder.method_23270() == class_2806.field_12803) {
            return CompletableFuture.completedFuture(true);
        }
        class_3193 unloadedChunkHolder = (class_3193)chunkStorageMixin.getChunksToUnload().get(chunkPos.method_8324());
        if (unloadedChunkHolder != null && unloadedChunkHolder.method_23270() == class_2806.field_12803) {
            return CompletableFuture.completedFuture(true);
        }
        if (UPDATE_CHUNK_NBT) {
            return chunkStorageMixin.invokeGetUpdatedChunkNbt(chunkPos).thenApply(optionalNbt -> optionalNbt.filter(chunkNbt -> chunkNbt.method_10573("Status", 8)).map(chunkNbt -> chunkNbt.method_10558("Status")).map(status -> "minecraft:full".equals(status) || "full".equals(status)).orElse(false));
        }
        class_6843 statusQuery = new class_6843(class_2519.field_21045, "Status");
        class_6841 statusCollector = new class_6841(new class_6843[]{statusQuery});
        return serverChunkManager.method_39777().method_39795(chunkPos, (class_6836)statusCollector).thenApply(ignored -> {
            class_2520 patt4535$temp = statusCollector.method_39887();
            if (patt4535$temp instanceof class_2487) {
                class_2487 chunkNbt = (class_2487)patt4535$temp;
                String status = chunkNbt.method_10558("Status");
                return "minecraft:full".equals(status) || "full".equals(status);
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Void> getChunkAtAsync(int x, int z) {
        if (Thread.currentThread() != this.serverWorld.method_8503().method_3777()) {
            return CompletableFuture.supplyAsync(() -> this.getChunkAtAsync(x, z), (Executor)this.serverWorld.method_8503()).join();
        }
        class_1923 chunkPos = new class_1923(x, z);
        class_3215 serverChunkManager = this.serverWorld.method_14178();
        serverChunkManager.method_17297(CHUNKY, chunkPos, 0, (Object)class_3902.field_17274);
        if (TICKING_LOAD_DURATION > 0) {
            serverChunkManager.method_17297(CHUNKY_TICKING, chunkPos, 1, (Object)class_3902.field_17274);
        }
        ((ServerChunkManagerMixin)serverChunkManager).invokeTick();
        class_3898 threadedAnvilChunkStorage = serverChunkManager.field_17254;
        ThreadedAnvilChunkStorageMixin threadedAnvilChunkStorageMixin = (ThreadedAnvilChunkStorageMixin)threadedAnvilChunkStorage;
        class_3193 chunkHolder = threadedAnvilChunkStorageMixin.invokeGetChunkHolder(chunkPos.method_8324());
        CompletableFuture<Object> chunkFuture = chunkHolder == null ? CompletableFuture.completedFuture(null) : CompletableFuture.allOf(chunkHolder.method_13993(class_2806.field_12803, threadedAnvilChunkStorage));
        chunkFuture.whenCompleteAsync((ignored, throwable) -> serverChunkManager.method_17300(CHUNKY, chunkPos, 0, (Object)class_3902.field_17274), (Executor)this.serverWorld.method_8503());
        return chunkFuture;
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSeaLevel() {
        return this.serverWorld.method_8615();
    }

    @Override
    public Location getSpawn() {
        class_2338 pos = this.serverWorld.method_43126();
        float angle = this.serverWorld.method_43127();
        return new Location(this, pos.method_10263(), pos.method_10264(), pos.method_10260(), angle, 0.0f);
    }

    @Override
    public Border getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public int getElevation(int x, int z) {
        int logicalHeight;
        int height = this.serverWorld.method_8497(x >> 4, z >> 4).method_12005(class_2902.class_2903.field_13197, x, z) + 1;
        if (height >= (logicalHeight = this.serverWorld.method_32819())) {
            class_2338.class_2339 pos = new class_2338.class_2339(x, logicalHeight, z);
            int air = 0;
            while (pos.method_10264() > this.serverWorld.method_31607()) {
                class_2680 blockState = this.serverWorld.method_8320((class_2338)(pos = pos.method_10098(class_2350.field_11033)));
                if (blockState.method_51367() && air > 1) {
                    return pos.method_10264() + 1;
                }
                air = blockState.method_26215() ? air + 1 : 0;
            }
        }
        return height;
    }

    @Override
    public int getMaxElevation() {
        return this.serverWorld.method_32819();
    }

    @Override
    public void playEffect(Player player, String effect) {
        Location location = player.getLocation();
        class_2338 pos = class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ());
        Input.tryInteger(effect).ifPresent(eventId -> this.serverWorld.method_8444(null, eventId.intValue(), pos, 0));
    }

    @Override
    public void playSound(Player player, String sound) {
        Location location = player.getLocation();
        this.serverWorld.method_8503().method_30611().method_33310(class_7924.field_41225).flatMap(soundEventRegistry -> soundEventRegistry.method_17966(class_2960.method_12829((String)sound))).ifPresent(soundEvent -> this.serverWorld.method_43128(null, location.getX(), location.getY(), location.getZ(), soundEvent, class_3419.field_15250, 2.0f, 1.0f));
    }

    @Override
    public Optional<Path> getDirectory(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Path directory = class_2874.method_12488((class_5321)this.serverWorld.method_27983(), (Path)this.serverWorld.method_8503().method_27050(class_5218.field_24188)).normalize().resolve(name);
        return Files.exists(directory, new LinkOption[0]) ? Optional.of(directory) : Optional.empty();
    }

    public class_3218 getServerWorld() {
        return this.serverWorld;
    }
}

