/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.fixmcstats;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class Config {
    private static Config INSTANCE;
    private final Logger logger;
    private final Path currentDirectory;
    private final Properties properties = new Properties();
    public boolean USE_CAMEL_CUSTOM_STAT;
    public boolean USE_CRAWL_CUSTOM_STAT;
    static final String CONFIG = "FixMCStatsConfig";

    public static Config instance() {
        return INSTANCE;
    }

    public static void initConfig(Logger logger) throws IOException, SecurityException, IllegalArgumentException {
        INSTANCE = new Config(logger).loadOrGenerateConfig();
    }

    Config(Logger logger) {
        this.logger = logger;
        this.currentDirectory = FabricLoader.getInstance().getConfigDir();
    }

    Config loadOrGenerateConfig() throws IOException, SecurityException, IllegalArgumentException {
        boolean alreadyExist = Files.exists(this.getConfigPath(), new LinkOption[0]);
        if (alreadyExist) {
            this.logger.info("Config file found loading it");
            FileInputStream input = new FileInputStream(this.getConfigPath().toString());
            this.properties.load(input);
            this.logger.info("File loaded inspecting config keys...");
            ((InputStream)input).close();
        } else {
            this.logger.info("No config file found creating it...");
        }
        boolean toStore = !alreadyExist;
        for (Configs value : Configs.values()) {
            if (value.deprecated) {
                if (!alreadyExist || !this.properties.containsKey(value.getKey())) continue;
                this.logger.info("Old config key found '{}' removing it", (Object)value.getKey());
                toStore = true;
                this.properties.remove(value.getKey());
                continue;
            }
            if (alreadyExist && this.properties.containsKey(value.getKey())) continue;
            if (alreadyExist) {
                this.logger.info("Adding missing config key {}", (Object)value.getKey());
            }
            toStore = true;
            this.properties.setProperty(value.getKey(), value.getDefault());
        }
        if (!toStore) {
            this.logger.info("All keys are setup correctly");
        }
        if (toStore) {
            FileOutputStream stream = new FileOutputStream(this.getConfigPath().toString());
            this.logger.info("Saving file...");
            this.properties.store(stream, null);
            this.logger.info("Saved!");
            stream.close();
        }
        this.logger.info("Loading all configs");
        this.USE_CAMEL_CUSTOM_STAT = Boolean.parseBoolean(this.properties.getProperty(Configs.CAMEL_STAT.getKey(), Configs.CAMEL_STAT.getDefault()));
        this.USE_CRAWL_CUSTOM_STAT = Boolean.parseBoolean(this.properties.getProperty(Configs.CRAWL_STAT.getKey(), Configs.CRAWL_STAT.getDefault()));
        return this;
    }

    public Path getConfigDirectoryPath() {
        return this.currentDirectory;
    }

    @NotNull
    public Path getConfigPath() {
        return this.getConfigDirectoryPath().resolve(CONFIG);
    }

    public void updateConfig(Configs config, String value) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.getConfigPath().toString());
        this.properties.setProperty(config.getKey(), value);
        this.properties.store(stream, null);
        stream.close();
    }

    public void removeFromConfig(String key) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.getConfigPath().toString());
        this.properties.remove(key);
        this.properties.store(stream, null);
        stream.close();
    }

    public static enum Configs {
        ELYTRA_FIX("elytra-experimental-fix", Boolean.TRUE.toString(), true),
        CAMEL_STAT("use-camel-riding-stat", Boolean.TRUE.toString()),
        CRAWL_STAT("use-crawling-stat", Boolean.TRUE.toString());

        private final String key;
        private final String def;
        private final boolean deprecated;

        private Configs(String key, String def) {
            this(key, def, false);
        }

        private Configs(String key, String def, boolean deprecated) {
            this.key = key;
            this.def = def;
            this.deprecated = deprecated;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefault() {
            return this.def;
        }
    }
}

