/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes.textured;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.RotatableSkybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.Utils;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blend;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.Rotation;
import java.util.Objects;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class TexturedSkybox
extends AbstractSkybox
implements RotatableSkybox {
    public Rotation rotation;
    public Blend blend;

    protected TexturedSkybox() {
    }

    protected TexturedSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend) {
        super(properties, conditions, decorations);
        this.blend = blend;
        this.rotation = properties.getRotation();
    }

    @Override
    public final void render(WorldRendererAccess worldRendererAccess, class_4587 matrixStack, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean thickFog, Runnable fogCallback) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        this.blend.applyBlendFunc(this.alpha);
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        Vector3f rotationStatic = this.rotation.getStatic();
        matrixStack.method_22903();
        double timeRotationX = Utils.calculateRotation(this.rotation.getRotationSpeedX(), this.rotation.getTimeShift().x(), this.rotation.getSkyboxRotation(), world);
        double timeRotationY = Utils.calculateRotation(this.rotation.getRotationSpeedY(), this.rotation.getTimeShift().y(), this.rotation.getSkyboxRotation(), world);
        double timeRotationZ = Utils.calculateRotation(this.rotation.getRotationSpeedZ(), this.rotation.getTimeShift().z(), this.rotation.getSkyboxRotation(), world);
        this.applyTimeRotation(matrixStack, (float)timeRotationX, (float)timeRotationY, (float)timeRotationZ);
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(rotationStatic.x()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationStatic.y()));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotationStatic.z()));
        this.renderSkybox(worldRendererAccess, matrixStack, tickDelta, camera, thickFog, fogCallback);
        matrixStack.method_22909();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        this.renderDecorations(worldRendererAccess, matrixStack, projectionMatrix, tickDelta, bufferBuilder, this.alpha, fogCallback);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public abstract void renderSkybox(WorldRendererAccess var1, class_4587 var2, float var3, class_4184 var4, boolean var5, Runnable var6);

    private void applyTimeRotation(class_4587 matrixStack, float timeRotationX, float timeRotationY, float timeRotationZ) {
        Vector3f timeRotationAxis = this.rotation.getAxis();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(timeRotationAxis.x()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(timeRotationAxis.y()));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(timeRotationAxis.z()));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(timeRotationX));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(timeRotationY));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(timeRotationZ));
        matrixStack.method_22907(class_7833.field_40717.rotationDegrees(timeRotationAxis.z()));
        matrixStack.method_22907(class_7833.field_40715.rotationDegrees(timeRotationAxis.y()));
        matrixStack.method_22907(class_7833.field_40713.rotationDegrees(timeRotationAxis.x()));
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }
}

