/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.EndSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.LegacyDeserializer;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.MonoColorSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.OverworldSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.AnimatedSquareTexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.MultiTextureSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.SingleSpriteAnimatedSquareTexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.SingleSpriteSquareTexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.SquareTexturedSkybox;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkyboxType<T extends Skybox> {
    public static final class_2378<SkyboxType<? extends Skybox>> REGISTRY = FabricRegistryBuilder.from((class_2385)new class_2370(class_5321.method_29180((class_2960)new class_2960("fabricskyboxes", "skybox_type")), Lifecycle.stable())).buildAndRegister();
    public static final SkyboxType<MonoColorSkybox> MONO_COLOR_SKYBOX = SkyboxType.register(Builder.create(MonoColorSkybox.class, "monocolor").legacySupported().deserializer(LegacyDeserializer.MONO_COLOR_SKYBOX_DESERIALIZER).factory(MonoColorSkybox::new).add(2, MonoColorSkybox.CODEC).build());
    public static final SkyboxType<OverworldSkybox> OVERWORLD_SKYBOX = SkyboxType.register(Builder.create(OverworldSkybox.class, "overworld").add(2, OverworldSkybox.CODEC).build());
    public static final SkyboxType<EndSkybox> END_SKYBOX = SkyboxType.register(Builder.create(EndSkybox.class, "end").add(2, EndSkybox.CODEC).build());
    public static final SkyboxType<SquareTexturedSkybox> SQUARE_TEXTURED_SKYBOX = SkyboxType.register(Builder.create(SquareTexturedSkybox.class, "square-textured").deserializer(LegacyDeserializer.SQUARE_TEXTURED_SKYBOX_DESERIALIZER).legacySupported().factory(SquareTexturedSkybox::new).add(2, SquareTexturedSkybox.CODEC).build());
    public static final SkyboxType<SingleSpriteSquareTexturedSkybox> SINGLE_SPRITE_SQUARE_TEXTURED_SKYBOX = SkyboxType.register(Builder.create(SingleSpriteSquareTexturedSkybox.class, "single-sprite-square-textured").add(2, SingleSpriteSquareTexturedSkybox.CODEC).build());
    public static final SkyboxType<AnimatedSquareTexturedSkybox> ANIMATED_SQUARE_TEXTURED_SKYBOX = SkyboxType.register(Builder.create(AnimatedSquareTexturedSkybox.class, "animated-square-textured").add(2, AnimatedSquareTexturedSkybox.CODEC).build());
    public static final SkyboxType<SingleSpriteAnimatedSquareTexturedSkybox> SINGLE_SPRITE_ANIMATED_SQUARE_TEXTURED_SKYBOX = SkyboxType.register(Builder.create(SingleSpriteAnimatedSquareTexturedSkybox.class, "single-sprite-animated-square-textured").add(2, SingleSpriteAnimatedSquareTexturedSkybox.CODEC).build());
    public static final SkyboxType<MultiTextureSkybox> MULTI_TEXTURE_SKYBOX = SkyboxType.register(Builder.create(MultiTextureSkybox.class, "multi-texture").add(2, MultiTextureSkybox.CODEC).build());
    public static final Codec<class_2960> SKYBOX_ID_CODEC = Codec.STRING.xmap(s -> {
        if (!s.contains(":")) {
            return new class_2960("fabricskyboxes", s.replace('-', '_'));
        }
        return new class_2960(s.replace('-', '_'));
    }, id -> {
        if (id.method_12836().equals("fabricskyboxes")) {
            return id.method_12832().replace('_', '-');
        }
        return id.toString().replace('_', '-');
    });
    private final BiMap<Integer, Codec<T>> codecBiMap;
    private final boolean legacySupported;
    private final String name;
    @Nullable
    private final Supplier<T> factory;
    @Nullable
    private final LegacyDeserializer<T> deserializer;

    private SkyboxType(BiMap<Integer, Codec<T>> codecBiMap, boolean legacySupported, String name, @Nullable Supplier<T> factory, @Nullable LegacyDeserializer<T> deserializer) {
        this.codecBiMap = codecBiMap;
        this.legacySupported = legacySupported;
        this.name = name;
        this.factory = factory;
        this.deserializer = deserializer;
    }

    public static void initRegistry() {
        if (REGISTRY == null) {
            System.err.println("[FabricSkyboxes] Registry not loaded?");
        }
    }

    private static <T extends Skybox> SkyboxType<T> register(SkyboxType<T> type) {
        return (SkyboxType)class_2378.method_10230(REGISTRY, (class_2960)type.createId("fabricskyboxes"), type);
    }

    public String getName() {
        return this.name;
    }

    public boolean isLegacySupported() {
        return this.legacySupported;
    }

    @NotNull
    public T instantiate() {
        return (T)Objects.requireNonNull((Skybox)Objects.requireNonNull(this.factory, "Can't instantiate from a null factory").get());
    }

    @Nullable
    public LegacyDeserializer<T> getDeserializer() {
        return this.deserializer;
    }

    public class_2960 createId(String namespace) {
        return this.createIdFactory().apply(namespace);
    }

    public Function<String, class_2960> createIdFactory() {
        return ns -> new class_2960(ns, this.getName().replace('-', '_'));
    }

    public Codec<T> getCodec(int schemaVersion) {
        return Objects.requireNonNull((Codec)this.codecBiMap.get((Object)schemaVersion), String.format("Unsupported schema version '%d' for skybox type %s", schemaVersion, this.name));
    }

    public static class Builder<T extends Skybox> {
        private final ImmutableBiMap.Builder<Integer, Codec<T>> builder = ImmutableBiMap.builder();
        private String name;
        private boolean legacySupported = false;
        private Supplier<T> factory;
        private LegacyDeserializer<T> deserializer;

        private Builder() {
        }

        public static <S extends Skybox> Builder<S> create(Class<S> clazz, String name) {
            Builder builder = new Builder();
            builder.name = name;
            return builder;
        }

        public static <S extends Skybox> Builder<S> create(String name) {
            Builder builder = new Builder();
            builder.name = name;
            return builder;
        }

        protected Builder<T> legacySupported() {
            this.legacySupported = true;
            return this;
        }

        protected Builder<T> factory(Supplier<T> factory) {
            this.factory = factory;
            return this;
        }

        protected Builder<T> deserializer(LegacyDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> add(int schemaVersion, Codec<T> codec) {
            Preconditions.checkArgument((schemaVersion >= 2 ? 1 : 0) != 0, (Object)"schema version was lesser than 2");
            Preconditions.checkNotNull(codec, (Object)"codec was null");
            this.builder.put((Object)schemaVersion, codec);
            return this;
        }

        public SkyboxType<T> build() {
            if (this.legacySupported) {
                Preconditions.checkNotNull(this.factory, (Object)"factory was null");
                Preconditions.checkNotNull(this.deserializer, (Object)"deserializer was null");
            }
            return new SkyboxType<T>(this.builder.build(), this.legacySupported, this.name, this.factory, this.deserializer);
        }

        public SkyboxType<T> buildAndRegister(String namespace) {
            return (SkyboxType)class_2378.method_10230(REGISTRY, (class_2960)new class_2960(namespace, this.name.replace('-', '_')), this.build());
        }
    }
}

