/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.CustomSound;
import de.maxhenkel.audioplayer.FileNameManager;
import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.command.UploadCommands;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_7445;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

@Command(value={"audioplayer"})
public class UtilityCommands {
    @RequiresPermission(value="audioplayer.apply")
    @Command(value={"clear"})
    public void clear(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid item"));
            return;
        }
        if (!CustomSound.clearItem(itemInHand)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Item does not have custom audio"));
            return;
        }
        if (itemInHand.method_57826(class_9334.field_49612)) {
            Optional holder = class_7923.field_41166.method_40264(class_7445.field_39126);
            holder.ifPresent(instrumentReference -> itemInHand.method_57379(class_9334.field_49612, instrumentReference));
        }
        if (itemInHand.method_57826(class_9334.field_49638)) {
            itemInHand.method_57381(class_9334.field_49638);
        }
        if (itemInHand.method_57826(class_9334.field_49632)) {
            itemInHand.method_57381(class_9334.field_49632);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully cleared item"), false);
    }

    @Command(value={"id"})
    public void id(CommandContext<class_2168> context) throws CommandSyntaxException {
        CustomSound customSound = UtilityCommands.getHeldSound(context);
        if (customSound == null) {
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> UploadCommands.sendUUIDMessage(customSound.getSoundId(), class_2561.method_43470((String)"Successfully extracted sound ID.")), false);
    }

    @Command(value={"name"})
    public void name(CommandContext<class_2168> context) throws CommandSyntaxException {
        CustomSound customSound = UtilityCommands.getHeldSound(context);
        if (customSound == null) {
            return;
        }
        Optional<FileNameManager> optionalMgr = FileNameManager.instance();
        if (optionalMgr.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"An internal error occurred"));
            return;
        }
        FileNameManager mgr = optionalMgr.get();
        String fileName = mgr.getFileName(customSound.getSoundId());
        if (fileName == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Custom audio does not have an associated file name"));
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Audio file name: ").method_10852((class_2561)class_2561.method_43470((String)fileName).method_27694(style -> style.method_10977(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, fileName)))), false);
    }

    private static CustomSound getHeldSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid item"));
            return null;
        }
        CustomSound customSound = CustomSound.of(itemInHand);
        if (customSound == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Item does not have custom audio"));
            return null;
        }
        return customSound;
    }
}

