/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.server.MinecraftServer;

public class Filebin {
    public static void downloadSound(MinecraftServer server, UUID sound) throws IOException, InterruptedException, UnsupportedAudioFileException {
        HttpRequest request;
        String url = Filebin.getBin(sound);
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(url)).header("Accept", "application/json").build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException(url + " responded with status " + response.statusCode());
        }
        JsonElement json = JsonParser.parseString((String)response.body());
        if (!(json instanceof JsonObject)) {
            throw new IOException("Invalid response");
        }
        JsonObject object = (JsonObject)json;
        JsonElement filesElement = object.get("files");
        if (filesElement == null) {
            throw new IOException("No files uploaded");
        }
        if (!(filesElement instanceof JsonArray)) {
            throw new IOException("No files uploaded");
        }
        JsonArray files = (JsonArray)filesElement;
        for (JsonElement element : files) {
            JsonObject file;
            String contentType;
            if (!(element instanceof JsonObject) || !(contentType = (file = (JsonObject)element).get("content-type").getAsString()).equals("audio/wav") && !contentType.equals("audio/mpeg")) continue;
            long size = file.get("bytes").getAsLong();
            if (size > AudioPlayer.SERVER_CONFIG.maxUploadSize.get()) {
                throw new IOException("Maximum file size exceeded (%sMB>%sMB)".formatted(Math.round((float)size / 1000000.0f), Math.round(AudioPlayer.SERVER_CONFIG.maxUploadSize.get().floatValue() / 1000000.0f)));
            }
            String filename = file.get("filename").getAsString();
            AudioManager.saveSound(server, sound, url + "/" + filename);
            return;
        }
        throw new IOException("No mp3 or wav files uploaded");
    }

    public static String getBin(UUID sound) {
        Object filebinUrl = AudioPlayer.SERVER_CONFIG.filebinUrl.get();
        if (!((String)filebinUrl).endsWith("/")) {
            filebinUrl = (String)filebinUrl + "/";
        }
        return (String)filebinUrl + String.valueOf(sound);
    }
}

