/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.admiral.permissions.PermissionManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import java.util.List;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class AudioPlayerPermissionManager
implements PermissionManager<class_2168> {
    public static final AudioPlayerPermissionManager INSTANCE = new AudioPlayerPermissionManager();
    private static final Permission UPLOAD_PERMISSION = new Permission("audioplayer.upload", PermissionType.EVERYONE);
    private static final Permission APPLY_PERMISSION = new Permission("audioplayer.apply", PermissionType.EVERYONE);
    private static final Permission APPLY_ANNOUNCER_PERMISSION = new AnnouncerPermission("audioplayer.set_static", PermissionType.EVERYONE);
    private static final Permission PLAY_COMMAND_PERMISSION = new Permission("audioplayer.play_command", PermissionType.OPS);
    private static final List<Permission> PERMISSIONS = List.of(UPLOAD_PERMISSION, APPLY_PERMISSION, APPLY_ANNOUNCER_PERMISSION, PLAY_COMMAND_PERMISSION);
    private static Boolean loaded;

    public boolean hasPermission(class_2168 stack, String permission) {
        for (Permission p : PERMISSIONS) {
            if (!p.permission.equals(permission)) continue;
            if (stack.method_43737()) {
                return p.hasPermission(stack.method_44023());
            }
            if (p.getType().equals((Object)PermissionType.OPS)) {
                return stack.method_9259(2);
            }
            return p.hasPermission(null);
        }
        return false;
    }

    private static boolean isFabricPermissionsAPILoaded() {
        if (loaded == null && (loaded = Boolean.valueOf(FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0"))).booleanValue()) {
            AudioPlayer.LOGGER.info("Using Fabric Permissions API");
        }
        return loaded;
    }

    private static class Permission {
        private final String permission;
        private final PermissionType type;

        public Permission(String permission, PermissionType type) {
            this.permission = permission;
            this.type = type;
        }

        public boolean hasPermission(@Nullable class_3222 player) {
            if (AudioPlayerPermissionManager.isFabricPermissionsAPILoaded()) {
                return this.checkFabricPermission(player);
            }
            return this.type.hasPermission(player);
        }

        private boolean checkFabricPermission(@Nullable class_3222 player) {
            if (player == null) {
                return false;
            }
            TriState permissionValue = Permissions.getPermissionValue((class_1297)player, (String)this.permission);
            switch (permissionValue) {
                case DEFAULT: {
                    return this.type.hasPermission(player);
                }
                case TRUE: {
                    return true;
                }
            }
            return false;
        }

        public PermissionType getType() {
            return this.type;
        }
    }

    private static enum PermissionType {
        EVERYONE,
        NOONE,
        OPS;


        boolean hasPermission(@Nullable class_3222 player) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case 2 -> player != null && player.method_5687(player.field_13995.method_3798());
            };
        }
    }

    private static class AnnouncerPermission
    extends Permission {
        public AnnouncerPermission(String permission, PermissionType type) {
            super(permission, type);
        }

        @Override
        public boolean hasPermission(@Nullable class_3222 player) {
            return AudioPlayer.SERVER_CONFIG.allowStaticAudio.get() != false && super.hasPermission(player);
        }
    }
}

