/*
 * Decompiled with CFR 0.152.
 */
package quilt.com.mrmelon54.MultipleServerLists.util;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.apache.commons.compress.utils.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quilt.com.mrmelon54.MultipleServerLists.duck.ServerListDuckProvider;

@Environment(value=EnvType.CLIENT)
public class CustomFileServerList
extends class_641 {
    private static final Logger LOGGER = LogManager.getLogger();
    private File serversWrapperFolder;
    private final class_310 client;
    private final int pageIndex;
    private String listName;

    public CustomFileServerList(class_310 client, int pageIndex) {
        super(client);
        this.client = client;
        this.pageIndex = pageIndex;
        this.listName = "Page " + pageIndex;
        this.method_2981();
    }

    public int index() {
        return this.pageIndex;
    }

    List<class_642> getInternalServers() {
        CustomFileServerList customFileServerList = this;
        if (customFileServerList instanceof ServerListDuckProvider) {
            ServerListDuckProvider duck = (ServerListDuckProvider)((Object)customFileServerList);
            return duck.multiple_server_lists$getServers();
        }
        return Lists.newArrayList();
    }

    List<class_642> getInternalHiddenServers() {
        CustomFileServerList customFileServerList = this;
        if (customFileServerList instanceof ServerListDuckProvider) {
            ServerListDuckProvider duck = (ServerListDuckProvider)((Object)customFileServerList);
            return duck.multiple_server_lists$getHiddenServers();
        }
        return Lists.newArrayList();
    }

    public boolean makeSureFolderExists() {
        if (this.serversWrapperFolder == null) {
            this.serversWrapperFolder = new File(this.client.field_1697, "s760");
        }
        return this.serversWrapperFolder.exists() || this.serversWrapperFolder.mkdirs();
    }

    public void method_2981() {
        try {
            this.getInternalServers().clear();
            this.getInternalHiddenServers().clear();
            if (this.makeSureFolderExists()) {
                class_2487 compoundTag = class_2507.method_10633((Path)new File(this.serversWrapperFolder, "servers" + this.pageIndex + ".dat").toPath());
                if (compoundTag == null) {
                    return;
                }
                if (compoundTag.method_10573("name", 8)) {
                    this.listName = compoundTag.method_10558("name");
                }
                class_2499 listTag = compoundTag.method_10554("servers", 10);
                for (int i = 0; i < listTag.size(); ++i) {
                    class_2487 c = listTag.method_10602(i);
                    class_642 serverInfo = class_642.method_2993((class_2487)c);
                    if (c.method_10577("hidden")) {
                        this.getInternalHiddenServers().add(serverInfo);
                        continue;
                    }
                    this.getInternalServers().add(serverInfo);
                }
            }
        }
        catch (Exception var4) {
            LOGGER.error("Couldn't load server list", (Throwable)var4);
        }
    }

    public void method_2987() {
        try {
            if (this.makeSureFolderExists()) {
                class_2487 c;
                class_2499 listTag = new class_2499();
                for (class_642 serverInfo : this.getInternalServers()) {
                    c = serverInfo.method_2992();
                    c.method_10556("hidden", false);
                    listTag.add((Object)c);
                }
                for (class_642 serverInfo : this.getInternalHiddenServers()) {
                    c = serverInfo.method_2992();
                    c.method_10556("hidden", true);
                    listTag.add((Object)c);
                }
                class_2487 compoundTag = new class_2487();
                compoundTag.method_10582("name", this.listName);
                compoundTag.method_10566("servers", (class_2520)listTag);
                String n = "servers" + this.pageIndex;
                File tempFile = File.createTempFile(n, ".dat", this.serversWrapperFolder);
                class_2507.method_10630((class_2487)compoundTag, (Path)tempFile.toPath());
                File serversDatOld = new File(this.serversWrapperFolder, n + ".dat_old");
                File serversDat = new File(this.serversWrapperFolder, n + ".dat");
                class_156.method_30626((Path)serversDat.toPath(), (Path)tempFile.toPath(), (Path)serversDatOld.toPath());
            }
        }
        catch (Exception var6) {
            LOGGER.error("Couldn't save server list", (Throwable)var6);
        }
    }

    public void deleteFile() {
        try {
            if (this.makeSureFolderExists()) {
                File file3 = new File(this.serversWrapperFolder, "servers" + this.pageIndex + ".dat");
                file3.delete();
            }
        }
        catch (Exception var6) {
            LOGGER.error("Couldn't remove the server list", (Throwable)var6);
        }
    }

    public void setName(String value) {
        this.listName = value;
    }

    public String getName() {
        return this.listName;
    }
}

