/*
 * Decompiled with CFR 0.152.
 */
package quilt.com.mrmelon54.MultipleServerLists.client.gui.components;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import quilt.com.mrmelon54.MultipleServerLists.MultipleServerLists;
import quilt.com.mrmelon54.MultipleServerLists.client.screen.EditListNameScreen;
import quilt.com.mrmelon54.MultipleServerLists.util.CustomFileServerList;

public class TabViewWidget
extends class_4280<TabWidget> {
    private static final class_8666 LEFT_ARROW_BUTTON = new class_8666(new class_2960("multiple-server-lists", "left_arrow"), new class_2960("multiple-server-lists", "left_arrow_disabled"), new class_2960("multiple-server-lists", "left_arrow_highlight"));
    private static final class_8666 RIGHT_ARROW_BUTTON = new class_8666(new class_2960("multiple-server-lists", "right_arrow"), new class_2960("multiple-server-lists", "right_arrow_disabled"), new class_2960("multiple-server-lists", "right_arrow_highlight"));
    private static final class_8666 ADD_BUTTON = new class_8666(new class_2960("multiple-server-lists", "add"), new class_2960("multiple-server-lists", "add_highlight"));
    private static final class_8666 TAB_SPRITE = new class_8666(new class_2960("multiple-server-lists", "tab"), new class_2960("multiple-server-lists", "tab_disabled"), new class_2960("multiple-server-lists", "tab_highlight"));
    private final class_1799 featherStack;
    private List<CustomFileServerList> serverLists;
    private ScrollableRegion scrollRegion;
    private final class_4185 scrollLeft;
    private final class_4185 scrollRight;
    private final class_4185 addTab;
    private final class_4185 editServerListNameButton;

    public TabViewWidget(class_310 mc, class_437 screen, int width, int top) {
        super(mc, width, 20, top, 20);
        this.method_31322(false);
        this.method_25315(false, 0);
        this.reloadTabList();
        this.featherStack = new class_1799((class_1935)class_1802.field_8153);
        this.scrollLeft = new class_344(0, top, 20, 20, LEFT_ARROW_BUTTON, button -> this.scrollRegion.scrollLeft());
        this.scrollRight = new class_344(width - 60, top, 20, 20, RIGHT_ARROW_BUTTON, button -> this.scrollRegion.scrollRight());
        this.addTab = new class_344(width - 40, top, 20, 20, ADD_BUTTON, button -> {
            List children = this.method_25396();
            int n = children.size() == 1 ? 0 : ((TabWidget)((Object)((Object)children.get((int)(children.size() - 1))))).list.index();
            CustomFileServerList list = new CustomFileServerList(mc, n + 1);
            this.serverLists.add(list);
            list.method_2987();
            this.refresh();
            for (TabWidget child : children) {
                if (child.list != list) continue;
                child.onPress.onPress(child);
                return;
            }
        });
        this.editServerListNameButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), button -> {
            List children = this.method_25396();
            int tab = MultipleServerLists.getTab() - 1;
            System.out.println("tab:" + tab);
            if (tab < 0 || tab > children.size()) {
                return;
            }
            CustomFileServerList currentServerList = ((TabWidget)((Object)((Object)children.get((int)tab)))).list;
            EditListNameScreen editListNameScreen = new EditListNameScreen((class_2561)class_2561.method_43471((String)"multiple-server-lists.screen.edit-list-name.title"), screen, currentServerList);
            if (mc != null) {
                mc.method_1507((class_437)editListNameScreen);
            }
        }).method_46434(width - 20, top, 20, 20).method_46431();
    }

    private void scrollToSelectedTab() {
        int selectedTab = MultipleServerLists.getTab();
        List children = this.method_25396();
        int childrenSize = children.size();
        for (int i = 0; i < childrenSize; ++i) {
            TabWidget child = (TabWidget)((Object)children.get(i));
            if (selectedTab != i) continue;
            child.onPress.onPress(child);
            break;
        }
    }

    public void reloadTabList() {
        int save = this.scrollRegion != null ? this.scrollRegion.scrollX : 0;
        this.serverLists = MultipleServerLists.getTabServerList();
        this.refresh();
        this.scrollRegion.scrollX = save;
        this.scrollToSelectedTab();
    }

    public void refresh() {
        List c = this.method_25396();
        c.clear();
        int totalWidth = 0;
        TabWidget t = new TabWidget(-200, 0, null, button -> {
            MultipleServerLists.setTab(0);
            this.scrollRegion.scrollToVisible(button.start - 20, button.start + button.getActualWidth() + 20);
        });
        totalWidth += t.getActualWidth();
        c.add(t);
        for (int i = 0; i < this.serverLists.size(); ++i) {
            CustomFileServerList serverList = this.serverLists.get(i);
            int j = i + 1;
            t = new TabWidget(-200, totalWidth, serverList, button -> {
                MultipleServerLists.setTab(j);
                this.scrollRegion.scrollToVisible(button.start - 20, button.start + button.getActualWidth() + 20);
            });
            totalWidth += t.getActualWidth();
            c.add(t);
        }
        this.scrollRegion = new ScrollableRegion(totalWidth, this.field_22758);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        int startX = this.scrollRegion.startScrollableX();
        List children = this.method_25396();
        int selectedTab = MultipleServerLists.getTab();
        int w = startX;
        int childrenSize = children.size();
        for (int i = 0; i < childrenSize; ++i) {
            boolean tabIsVisible;
            TabWidget child = (TabWidget)((Object)children.get(i));
            int a = child.getActualWidth();
            boolean bl = tabIsVisible = w <= this.scrollRegion.viewWidth && w + a >= 0;
            if (tabIsVisible) {
                boolean hovered = mouseY >= this.method_46427() && mouseY < this.method_55443() && this.scrollRegion.isHovered(mouseX) && mouseX >= w && mouseX < w + a;
                child.selected = selectedTab == i;
                child.method_25343(guiGraphics, i, this.method_46427(), w, a, 20, mouseX, mouseY, hovered, delta);
            }
            w += a;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 50.0f);
        if (this.scrollRegion.needsScroll()) {
            this.scrollLeft.field_22763 = this.scrollRegion.canScrollLeft();
            this.scrollLeft.method_25394(guiGraphics, mouseX, mouseY, delta);
            this.scrollRight.field_22763 = this.scrollRegion.canScrollRight();
            this.scrollRight.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        this.addTab.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.editServerListNameButton.field_22763 = selectedTab > 0;
        this.editServerListNameButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (this.featherStack != null) {
            guiGraphics.method_51445(this.featherStack, this.field_22758 - 18, this.method_46427() + 2);
        }
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < (double)this.method_46427() || mouseY >= (double)this.method_55443()) {
            return false;
        }
        if (this.scrollRegion.needsScroll()) {
            if (this.scrollLeft.method_25405(mouseX, mouseY)) {
                return this.scrollLeft.method_25402(mouseX, mouseY, button);
            }
            if (this.scrollRight.method_25405(mouseX, mouseY)) {
                return this.scrollRight.method_25402(mouseX, mouseY, button);
            }
        }
        if (this.addTab.method_25405(mouseX, mouseY)) {
            return this.addTab.method_25402(mouseX, mouseY, button);
        }
        if (this.editServerListNameButton.method_25405(mouseX, mouseY)) {
            return this.editServerListNameButton.method_25402(mouseX, mouseY, button);
        }
        int x = (int)mouseX - this.scrollRegion.startScrollableX();
        List children = this.method_25396();
        for (TabWidget child : children) {
            if (x < child.start || x >= child.start + child.getActualWidth()) continue;
            return child.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @NotNull
    public Optional<class_364> method_19355(double d, double e) {
        return super.method_19355(d, e);
    }

    public boolean method_25404(int i, int j, int k) {
        return super.method_25404(i, j, k);
    }

    public class TabWidget
    extends class_4280.class_4281<TabWidget> {
        private final int width;
        private final class_2561 message;
        private final PressAction onPress;
        public final int start;
        public boolean selected;
        public CustomFileServerList list;

        public TabWidget(int width, int start, CustomFileServerList serverList, PressAction onPress) {
            this.width = width;
            this.start = start;
            this.message = class_2561.method_43470((String)(serverList == null ? "Main" : serverList.getName()));
            this.onPress = onPress;
            this.list = serverList;
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        @NotNull
        public class_2561 method_37006() {
            return this.message;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.onPress.onPress(this);
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return super.method_25406(mouseX, mouseY, button);
        }

        public void method_25343(class_332 guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int w = this.getActualWidth();
            int wLeft = class_3532.method_48116((int)w, (int)2);
            guiGraphics.method_52706(TAB_SPRITE.method_52729(!this.selected, hovered), x, y, w, entryHeight);
            guiGraphics.method_27534(((TabViewWidget)TabViewWidget.this).field_22740.field_1772, this.message, x + wLeft, y + (TabViewWidget.this.field_22759 - 8) / 2, -1);
        }

        public int getActualWidth() {
            return this.width < 0 ? Math.max(20, ((TabViewWidget)TabViewWidget.this).field_22740.field_1772.method_27525((class_5348)this.message) + 12) : this.width;
        }

        @Environment(value=EnvType.CLIENT)
        public static interface PressAction {
            public void onPress(TabWidget var1);
        }
    }

    public static class ScrollableRegion {
        private final int totalWidth;
        private final int viewWidth;
        public int scrollX;

        public ScrollableRegion(int totalWidth, int scrollableWidth) {
            this.totalWidth = totalWidth;
            this.viewWidth = scrollableWidth;
        }

        private boolean needsScroll() {
            return this.totalWidth >= this.viewWidth - 40;
        }

        public int getStartX() {
            return this.needsScroll() ? 20 : 0;
        }

        public int getEndX() {
            return this.viewWidth - (this.needsScroll() ? 60 : 40);
        }

        public int scrollableWidth() {
            return this.getEndX() - this.getStartX();
        }

        public int startScrollableX() {
            return this.getStartX() - this.scrollX;
        }

        public boolean isHovered(int mouseX) {
            return mouseX >= this.getStartX() && mouseX < this.getEndX();
        }

        public boolean canScrollLeft() {
            return this.scrollX > 0;
        }

        public boolean canScrollRight() {
            return this.scrollX < this.totalWidth - this.scrollableWidth();
        }

        public void scrollLeft() {
            this.scrollX = Math.max(0, this.scrollX - 80);
        }

        public void scrollRight() {
            this.scrollX = Math.min(this.totalWidth - this.scrollableWidth(), this.scrollX + 80);
        }

        public void scrollToVisible(int startX, int endX) {
            int scrollStart = startX + this.startScrollableX();
            int scrollEnd = endX + this.startScrollableX();
            if (scrollStart < 0) {
                this.scrollX = Math.max(0, startX);
            }
            if (scrollEnd >= this.scrollableWidth()) {
                this.scrollX = Math.min(this.totalWidth - this.scrollableWidth(), endX - this.scrollableWidth());
            }
        }
    }
}

