/*
 * Decompiled with CFR 0.152.
 */
package quilt.com.mrmelon54.MultipleServerLists;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_641;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quilt.com.mrmelon54.MultipleServerLists.config.ConfigStructure;
import quilt.com.mrmelon54.MultipleServerLists.duck.MultiplayerScreenDuckProvider;
import quilt.com.mrmelon54.MultipleServerLists.util.CustomFileServerList;

public class MultipleServerLists {
    public static final Logger LOGGER = LoggerFactory.getLogger(MultipleServerLists.class);
    public static final String MOD_ID = "multiple_server_lists";
    private static final Pattern pattern = Pattern.compile("servers([0-9]+)\\.dat");
    private static MultiplayerScreenDuckProvider multiplayerScreenDuckProvider;
    public static ConfigStructure config;

    public static void init() {
        AutoConfig.register(ConfigStructure.class, JanksonConfigSerializer::new);
        config = (ConfigStructure)AutoConfig.getConfigHolder(ConfigStructure.class).getConfig();
    }

    public static class_437 createConfigScreen(class_437 parent) {
        return (class_437)AutoConfig.getConfigScreen(ConfigStructure.class, (class_437)parent).get();
    }

    public static List<Integer> getTabList() {
        ArrayList<Integer> availableTabs = new ArrayList<Integer>();
        class_310 mc = class_310.method_1551();
        File s760nbt = new File(mc.field_1697, "s760");
        if (s760nbt.exists()) {
            Predicate<String> patternPredicate = pattern.asMatchPredicate();
            File[] files = s760nbt.listFiles((dir, name) -> patternPredicate.test(name));
            if (files != null) {
                for (File file : files) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.find()) continue;
                    try {
                        availableTabs.add(Integer.parseInt(matcher.group(1)));
                    }
                    catch (NumberFormatException ignored) {
                        LOGGER.error("The number " + matcher.group(1) + " was unable to be read so the file was not included in the merged vanilla server lists");
                        LOGGER.error("If this resulted in missing servers then please inform the developer via Discord, CurseForge or GitHub");
                    }
                }
            }
            Collections.sort(availableTabs);
        }
        return availableTabs;
    }

    public static List<CustomFileServerList> getTabServerList() {
        class_310 mc = class_310.method_1551();
        List<Integer> tabList = MultipleServerLists.getTabList();
        return tabList.stream().map(n -> new CustomFileServerList(mc, (int)n)).collect(Collectors.toList());
    }

    public static void safeUninstallForVanilla() {
        class_310 mc = class_310.method_1551();
        List<Integer> tabList = MultipleServerLists.getTabList();
        class_641 mainTab = MultipleServerLists.getServerListForTab(mc, 0);
        if (mainTab == null) {
            LOGGER.error("Failed to load server list for main tab");
            return;
        }
        mainTab.method_2981();
        for (int a : tabList) {
            class_641 currentTab = MultipleServerLists.getServerListForTab(mc, a);
            if (currentTab == null) {
                LOGGER.error("Failed to load server list for tab " + a);
                return;
            }
            currentTab.method_2981();
            for (int i = 0; i < currentTab.method_2984(); ++i) {
                mainTab.method_2988(currentTab.method_2982(i), false);
            }
        }
        mainTab.method_2987();
        for (int a : tabList) {
            class_641 class_6412 = MultipleServerLists.getServerListForTab(mc, a);
            if (!(class_6412 instanceof CustomFileServerList)) continue;
            CustomFileServerList customFileServerList = (CustomFileServerList)class_6412;
            customFileServerList.deleteFile();
        }
    }

    public static class_641 getServerListForTab(class_310 mc, int tab) {
        if (tab < 0) {
            return null;
        }
        return tab == 0 ? new class_641(mc) : new CustomFileServerList(mc, tab);
    }

    public static void setMultiplayerScreen(MultiplayerScreenDuckProvider duck) {
        multiplayerScreenDuckProvider = duck;
    }

    public static void setTab(int n) {
        if (multiplayerScreenDuckProvider != null) {
            multiplayerScreenDuckProvider.multiple_server_lists$setCurrentTab(n);
        }
    }

    public static int getTab() {
        return multiplayerScreenDuckProvider != null ? multiplayerScreenDuckProvider.multiple_server_lists$getCurrentTab() : 0;
    }
}

