/*
 * Decompiled with CFR 0.152.
 */
package forge.com.mrmelon54.MultipleServerLists.util;

import forge.com.mrmelon54.MultipleServerLists.duck.ServerListDuckProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CustomFileServerList
extends ServerList {
    private static final Logger LOGGER = LogManager.getLogger();
    private File serversWrapperFolder;
    private final Minecraft client;
    private final int pageIndex;
    private String listName;

    public CustomFileServerList(Minecraft client, int pageIndex) {
        super(client);
        this.client = client;
        this.pageIndex = pageIndex;
        this.listName = "Page " + pageIndex;
        this.m_105431_();
    }

    public int index() {
        return this.pageIndex;
    }

    List<ServerData> getInternalServers() {
        CustomFileServerList customFileServerList = this;
        if (customFileServerList instanceof ServerListDuckProvider) {
            ServerListDuckProvider duck = (ServerListDuckProvider)((Object)customFileServerList);
            return duck.multiple_server_lists$getServers();
        }
        return Lists.newArrayList();
    }

    List<ServerData> getInternalHiddenServers() {
        CustomFileServerList customFileServerList = this;
        if (customFileServerList instanceof ServerListDuckProvider) {
            ServerListDuckProvider duck = (ServerListDuckProvider)((Object)customFileServerList);
            return duck.multiple_server_lists$getHiddenServers();
        }
        return Lists.newArrayList();
    }

    public boolean makeSureFolderExists() {
        if (this.serversWrapperFolder == null) {
            this.serversWrapperFolder = new File(this.client.f_91069_, "s760");
        }
        return this.serversWrapperFolder.exists() || this.serversWrapperFolder.mkdirs();
    }

    public void m_105431_() {
        try {
            this.getInternalServers().clear();
            this.getInternalHiddenServers().clear();
            if (this.makeSureFolderExists()) {
                CompoundTag compoundTag = NbtIo.m_128953_((Path)new File(this.serversWrapperFolder, "servers" + this.pageIndex + ".dat").toPath());
                if (compoundTag == null) {
                    return;
                }
                if (compoundTag.m_128425_("name", 8)) {
                    this.listName = compoundTag.m_128461_("name");
                }
                ListTag listTag = compoundTag.m_128437_("servers", 10);
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag c = listTag.m_128728_(i);
                    ServerData serverInfo = ServerData.m_105385_((CompoundTag)c);
                    if (c.m_128471_("hidden")) {
                        this.getInternalHiddenServers().add(serverInfo);
                        continue;
                    }
                    this.getInternalServers().add(serverInfo);
                }
            }
        }
        catch (Exception var4) {
            LOGGER.error("Couldn't load server list", (Throwable)var4);
        }
    }

    public void m_105442_() {
        try {
            if (this.makeSureFolderExists()) {
                CompoundTag c;
                ListTag listTag = new ListTag();
                for (ServerData serverInfo : this.getInternalServers()) {
                    c = serverInfo.m_105378_();
                    c.m_128379_("hidden", false);
                    listTag.add((Object)c);
                }
                for (ServerData serverInfo : this.getInternalHiddenServers()) {
                    c = serverInfo.m_105378_();
                    c.m_128379_("hidden", true);
                    listTag.add((Object)c);
                }
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128359_("name", this.listName);
                compoundTag.m_128365_("servers", (Tag)listTag);
                String n = "servers" + this.pageIndex;
                File tempFile = File.createTempFile(n, ".dat", this.serversWrapperFolder);
                NbtIo.m_128955_((CompoundTag)compoundTag, (Path)tempFile.toPath());
                File serversDatOld = new File(this.serversWrapperFolder, n + ".dat_old");
                File serversDat = new File(this.serversWrapperFolder, n + ".dat");
                Util.m_137505_((Path)serversDat.toPath(), (Path)tempFile.toPath(), (Path)serversDatOld.toPath());
            }
        }
        catch (Exception var6) {
            LOGGER.error("Couldn't save server list", (Throwable)var6);
        }
    }

    public void deleteFile() {
        try {
            if (this.makeSureFolderExists()) {
                File file3 = new File(this.serversWrapperFolder, "servers" + this.pageIndex + ".dat");
                file3.delete();
            }
        }
        catch (Exception var6) {
            LOGGER.error("Couldn't remove the server list", (Throwable)var6);
        }
    }

    public void setName(String value) {
        this.listName = value;
    }

    public String getName() {
        return this.listName;
    }
}

