/*
 * Decompiled with CFR 0.152.
 */
package forge.com.mrmelon54.MultipleServerLists.client.gui.components;

import forge.com.mrmelon54.MultipleServerLists.MultipleServerLists;
import forge.com.mrmelon54.MultipleServerLists.client.screen.EditListNameScreen;
import forge.com.mrmelon54.MultipleServerLists.util.CustomFileServerList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TabViewWidget
extends ObjectSelectionList<TabWidget> {
    private static final WidgetSprites LEFT_ARROW_BUTTON = new WidgetSprites(new ResourceLocation("multiple-server-lists", "left_arrow"), new ResourceLocation("multiple-server-lists", "left_arrow_disabled"), new ResourceLocation("multiple-server-lists", "left_arrow_highlight"));
    private static final WidgetSprites RIGHT_ARROW_BUTTON = new WidgetSprites(new ResourceLocation("multiple-server-lists", "right_arrow"), new ResourceLocation("multiple-server-lists", "right_arrow_disabled"), new ResourceLocation("multiple-server-lists", "right_arrow_highlight"));
    private static final WidgetSprites ADD_BUTTON = new WidgetSprites(new ResourceLocation("multiple-server-lists", "add"), new ResourceLocation("multiple-server-lists", "add_highlight"));
    private static final WidgetSprites TAB_SPRITE = new WidgetSprites(new ResourceLocation("multiple-server-lists", "tab"), new ResourceLocation("multiple-server-lists", "tab_disabled"), new ResourceLocation("multiple-server-lists", "tab_highlight"));
    private final ItemStack featherStack;
    private List<CustomFileServerList> serverLists;
    private ScrollableRegion scrollRegion;
    private final Button scrollLeft;
    private final Button scrollRight;
    private final Button addTab;
    private final Button editServerListNameButton;

    public TabViewWidget(Minecraft mc, Screen screen, int width, int top) {
        super(mc, width, 20, top, 20);
        this.m_93488_(false);
        this.m_93473_(false, 0);
        this.reloadTabList();
        this.featherStack = new ItemStack((ItemLike)Items.f_42402_);
        this.scrollLeft = new ImageButton(0, top, 20, 20, LEFT_ARROW_BUTTON, button -> this.scrollRegion.scrollLeft());
        this.scrollRight = new ImageButton(width - 60, top, 20, 20, RIGHT_ARROW_BUTTON, button -> this.scrollRegion.scrollRight());
        this.addTab = new ImageButton(width - 40, top, 20, 20, ADD_BUTTON, button -> {
            List children = this.m_6702_();
            int n = children.size() == 1 ? 0 : ((TabWidget)((Object)((Object)children.get((int)(children.size() - 1))))).list.index();
            CustomFileServerList list = new CustomFileServerList(mc, n + 1);
            this.serverLists.add(list);
            list.m_105442_();
            this.refresh();
            for (TabWidget child : children) {
                if (child.list != list) continue;
                child.onPress.onPress(child);
                return;
            }
        });
        this.editServerListNameButton = Button.m_253074_((Component)Component.m_237113_((String)""), button -> {
            List children = this.m_6702_();
            int tab = MultipleServerLists.getTab() - 1;
            System.out.println("tab:" + tab);
            if (tab < 0 || tab > children.size()) {
                return;
            }
            CustomFileServerList currentServerList = ((TabWidget)((Object)((Object)children.get((int)tab)))).list;
            EditListNameScreen editListNameScreen = new EditListNameScreen((Component)Component.m_237115_((String)"multiple-server-lists.screen.edit-list-name.title"), screen, currentServerList);
            if (mc != null) {
                mc.m_91152_((Screen)editListNameScreen);
            }
        }).m_252987_(width - 20, top, 20, 20).m_253136_();
    }

    private void scrollToSelectedTab() {
        int selectedTab = MultipleServerLists.getTab();
        List children = this.m_6702_();
        int childrenSize = children.size();
        for (int i = 0; i < childrenSize; ++i) {
            TabWidget child = (TabWidget)((Object)children.get(i));
            if (selectedTab != i) continue;
            child.onPress.onPress(child);
            break;
        }
    }

    public void reloadTabList() {
        int save = this.scrollRegion != null ? this.scrollRegion.scrollX : 0;
        this.serverLists = MultipleServerLists.getTabServerList();
        this.refresh();
        this.scrollRegion.scrollX = save;
        this.scrollToSelectedTab();
    }

    public void refresh() {
        List c = this.m_6702_();
        c.clear();
        int totalWidth = 0;
        TabWidget t = new TabWidget(-200, 0, null, button -> {
            MultipleServerLists.setTab(0);
            this.scrollRegion.scrollToVisible(button.start - 20, button.start + button.getActualWidth() + 20);
        });
        totalWidth += t.getActualWidth();
        c.add(t);
        for (int i = 0; i < this.serverLists.size(); ++i) {
            CustomFileServerList serverList = this.serverLists.get(i);
            int j = i + 1;
            t = new TabWidget(-200, totalWidth, serverList, button -> {
                MultipleServerLists.setTab(j);
                this.scrollRegion.scrollToVisible(button.start - 20, button.start + button.getActualWidth() + 20);
            });
            totalWidth += t.getActualWidth();
            c.add(t);
        }
        this.scrollRegion = new ScrollableRegion(totalWidth, this.f_93618_);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int startX = this.scrollRegion.startScrollableX();
        List children = this.m_6702_();
        int selectedTab = MultipleServerLists.getTab();
        int w = startX;
        int childrenSize = children.size();
        for (int i = 0; i < childrenSize; ++i) {
            boolean tabIsVisible;
            TabWidget child = (TabWidget)((Object)children.get(i));
            int a = child.getActualWidth();
            boolean bl = tabIsVisible = w <= this.scrollRegion.viewWidth && w + a >= 0;
            if (tabIsVisible) {
                boolean hovered = mouseY >= this.m_252907_() && mouseY < this.m_306468_() && this.scrollRegion.isHovered(mouseX) && mouseX >= w && mouseX < w + a;
                child.selected = selectedTab == i;
                child.m_6311_(guiGraphics, i, this.m_252907_(), w, a, 20, mouseX, mouseY, hovered, delta);
            }
            w += a;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
        if (this.scrollRegion.needsScroll()) {
            this.scrollLeft.f_93623_ = this.scrollRegion.canScrollLeft();
            this.scrollLeft.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.scrollRight.f_93623_ = this.scrollRegion.canScrollRight();
            this.scrollRight.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
        this.addTab.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.editServerListNameButton.f_93623_ = selectedTab > 0;
        this.editServerListNameButton.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (this.featherStack != null) {
            guiGraphics.m_280203_(this.featherStack, this.f_93618_ - 18, this.m_252907_() + 2);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY < (double)this.m_252907_() || mouseY >= (double)this.m_306468_()) {
            return false;
        }
        if (this.scrollRegion.needsScroll()) {
            if (this.scrollLeft.m_5953_(mouseX, mouseY)) {
                return this.scrollLeft.m_6375_(mouseX, mouseY, button);
            }
            if (this.scrollRight.m_5953_(mouseX, mouseY)) {
                return this.scrollRight.m_6375_(mouseX, mouseY, button);
            }
        }
        if (this.addTab.m_5953_(mouseX, mouseY)) {
            return this.addTab.m_6375_(mouseX, mouseY, button);
        }
        if (this.editServerListNameButton.m_5953_(mouseX, mouseY)) {
            return this.editServerListNameButton.m_6375_(mouseX, mouseY, button);
        }
        int x = (int)mouseX - this.scrollRegion.startScrollableX();
        List children = this.m_6702_();
        for (TabWidget child : children) {
            if (x < child.start || x >= child.start + child.getActualWidth()) continue;
            return child.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @NotNull
    public Optional<GuiEventListener> m_94729_(double d, double e) {
        return super.m_94729_(d, e);
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k);
    }

    public class TabWidget
    extends ObjectSelectionList.Entry<TabWidget> {
        private final int width;
        private final Component message;
        private final PressAction onPress;
        public final int start;
        public boolean selected;
        public CustomFileServerList list;

        public TabWidget(int width, int start, CustomFileServerList serverList, PressAction onPress) {
            this.width = width;
            this.start = start;
            this.message = Component.m_237113_((String)(serverList == null ? "Main" : serverList.getName()));
            this.onPress = onPress;
            this.list = serverList;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        @NotNull
        public Component m_142172_() {
            return this.message;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.onPress.onPress(this);
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return super.m_6348_(mouseX, mouseY, button);
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int w = this.getActualWidth();
            int wLeft = Mth.m_14042_((int)w, (int)2);
            guiGraphics.m_292816_(TAB_SPRITE.m_295557_(!this.selected, hovered), x, y, w, entryHeight);
            guiGraphics.m_280653_(((TabViewWidget)TabViewWidget.this).f_93386_.f_91062_, this.message, x + wLeft, y + (TabViewWidget.this.f_93619_ - 8) / 2, -1);
        }

        public int getActualWidth() {
            return this.width < 0 ? Math.max(20, ((TabViewWidget)TabViewWidget.this).f_93386_.f_91062_.m_92852_((FormattedText)this.message) + 12) : this.width;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static interface PressAction {
            public void onPress(TabWidget var1);
        }
    }

    public static class ScrollableRegion {
        private final int totalWidth;
        private final int viewWidth;
        public int scrollX;

        public ScrollableRegion(int totalWidth, int scrollableWidth) {
            this.totalWidth = totalWidth;
            this.viewWidth = scrollableWidth;
        }

        private boolean needsScroll() {
            return this.totalWidth >= this.viewWidth - 40;
        }

        public int getStartX() {
            return this.needsScroll() ? 20 : 0;
        }

        public int getEndX() {
            return this.viewWidth - (this.needsScroll() ? 60 : 40);
        }

        public int scrollableWidth() {
            return this.getEndX() - this.getStartX();
        }

        public int startScrollableX() {
            return this.getStartX() - this.scrollX;
        }

        public boolean isHovered(int mouseX) {
            return mouseX >= this.getStartX() && mouseX < this.getEndX();
        }

        public boolean canScrollLeft() {
            return this.scrollX > 0;
        }

        public boolean canScrollRight() {
            return this.scrollX < this.totalWidth - this.scrollableWidth();
        }

        public void scrollLeft() {
            this.scrollX = Math.max(0, this.scrollX - 80);
        }

        public void scrollRight() {
            this.scrollX = Math.min(this.totalWidth - this.scrollableWidth(), this.scrollX + 80);
        }

        public void scrollToVisible(int startX, int endX) {
            int scrollStart = startX + this.startScrollableX();
            int scrollEnd = endX + this.startScrollableX();
            if (scrollStart < 0) {
                this.scrollX = Math.max(0, startX);
            }
            if (scrollEnd >= this.scrollableWidth()) {
                this.scrollX = Math.min(this.totalWidth - this.scrollableWidth(), endX - this.scrollableWidth());
            }
        }
    }
}

