/*
 * Decompiled with CFR 0.152.
 */
package forge.com.mrmelon54.MultipleServerLists;

import forge.com.mrmelon54.MultipleServerLists.config.ConfigStructure;
import forge.com.mrmelon54.MultipleServerLists.duck.MultiplayerScreenDuckProvider;
import forge.com.mrmelon54.MultipleServerLists.util.CustomFileServerList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleServerLists {
    public static final Logger LOGGER = LoggerFactory.getLogger(MultipleServerLists.class);
    public static final String MOD_ID = "multiple_server_lists";
    private static final Pattern pattern = Pattern.compile("servers([0-9]+)\\.dat");
    private static MultiplayerScreenDuckProvider multiplayerScreenDuckProvider;
    public static ConfigStructure config;

    public static void init() {
        AutoConfig.register(ConfigStructure.class, JanksonConfigSerializer::new);
        config = (ConfigStructure)AutoConfig.getConfigHolder(ConfigStructure.class).getConfig();
    }

    public static Screen createConfigScreen(Screen parent) {
        return (Screen)AutoConfig.getConfigScreen(ConfigStructure.class, (Screen)parent).get();
    }

    public static List<Integer> getTabList() {
        ArrayList<Integer> availableTabs = new ArrayList<Integer>();
        Minecraft mc = Minecraft.m_91087_();
        File s760nbt = new File(mc.f_91069_, "s760");
        if (s760nbt.exists()) {
            Predicate<String> patternPredicate = pattern.asMatchPredicate();
            File[] files = s760nbt.listFiles((dir, name) -> patternPredicate.test(name));
            if (files != null) {
                for (File file : files) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.find()) continue;
                    try {
                        availableTabs.add(Integer.parseInt(matcher.group(1)));
                    }
                    catch (NumberFormatException ignored) {
                        LOGGER.error("The number " + matcher.group(1) + " was unable to be read so the file was not included in the merged vanilla server lists");
                        LOGGER.error("If this resulted in missing servers then please inform the developer via Discord, CurseForge or GitHub");
                    }
                }
            }
            Collections.sort(availableTabs);
        }
        return availableTabs;
    }

    public static List<CustomFileServerList> getTabServerList() {
        Minecraft mc = Minecraft.m_91087_();
        List<Integer> tabList = MultipleServerLists.getTabList();
        return tabList.stream().map(n -> new CustomFileServerList(mc, (int)n)).collect(Collectors.toList());
    }

    public static void safeUninstallForVanilla() {
        Minecraft mc = Minecraft.m_91087_();
        List<Integer> tabList = MultipleServerLists.getTabList();
        ServerList mainTab = MultipleServerLists.getServerListForTab(mc, 0);
        if (mainTab == null) {
            LOGGER.error("Failed to load server list for main tab");
            return;
        }
        mainTab.m_105431_();
        for (int a : tabList) {
            ServerList currentTab = MultipleServerLists.getServerListForTab(mc, a);
            if (currentTab == null) {
                LOGGER.error("Failed to load server list for tab " + a);
                return;
            }
            currentTab.m_105431_();
            for (int i = 0; i < currentTab.m_105445_(); ++i) {
                mainTab.m_233842_(currentTab.m_105432_(i), false);
            }
        }
        mainTab.m_105442_();
        for (int a : tabList) {
            ServerList serverList = MultipleServerLists.getServerListForTab(mc, a);
            if (!(serverList instanceof CustomFileServerList)) continue;
            CustomFileServerList customFileServerList = (CustomFileServerList)serverList;
            customFileServerList.deleteFile();
        }
    }

    public static ServerList getServerListForTab(Minecraft mc, int tab) {
        if (tab < 0) {
            return null;
        }
        return tab == 0 ? new ServerList(mc) : new CustomFileServerList(mc, tab);
    }

    public static void setMultiplayerScreen(MultiplayerScreenDuckProvider duck) {
        multiplayerScreenDuckProvider = duck;
    }

    public static void setTab(int n) {
        if (multiplayerScreenDuckProvider != null) {
            multiplayerScreenDuckProvider.multiple_server_lists$setCurrentTab(n);
        }
    }

    public static int getTab() {
        return multiplayerScreenDuckProvider != null ? multiplayerScreenDuckProvider.multiple_server_lists$getCurrentTab() : 0;
    }
}

