/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.daflight.handlers;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import xyz.deftu.daflight.DaFlight;
import xyz.deftu.daflight.utils.FlightMode;
import xyz.deftu.daflight.utils.Rotation;
import xyz.deftu.daflight.utils.Vector3D;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b'\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b5\u0010\u0016J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\u000bJ\r\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000bJ\r\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\bJ\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bJ\u000f\u0010\u0015\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u001f\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\u0019J\u0015\u0010\"\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010\u0019J\u000f\u0010#\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b#\u0010\u000bJ\u000f\u0010$\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b$\u0010\u000bR\u0016\u0010%\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0016\u0010(\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u0016\u0010)\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010&R\"\u0010*\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010+\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\u0016\u0010\u001d\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010+R\u0016\u0010\u001e\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010+R\u0016\u00103\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010&R\u0016\u00104\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u0010&\u00a8\u00066"}, d2={"Lxyz/deftu/daflight/handlers/MovementHandler;", "", "Lxyz/deftu/daflight/utils/Vector3D;", "vec", "Lxyz/deftu/daflight/utils/Rotation;", "rotation", "", "applyMovement", "(Lxyz/deftu/daflight/utils/Vector3D;Lxyz/deftu/daflight/utils/Rotation;)V", "", "isFlyBoosting", "()Z", "isFlying", "isSprintBoosting", "isSprinting", "", "original", "jump", "(F)F", "moveFlying", "moveSprinting", "reset", "()V", "state", "setAscending", "(Z)V", "setDescending", "setFlyBoosting", "setFlying", "moveForward", "moveStrafe", "setMovement", "(FF)V", "setSprintBoosting", "setSprinting", "shouldDisableFov", "shouldDisableViewBobbing", "ascending", "Z", "descending", "flyBoosting", "flying", "maxFlySpeed", "F", "getMaxFlySpeed", "()F", "setMaxFlySpeed", "(F)V", "maxWalkSpeed", "getMaxWalkSpeed", "setMaxWalkSpeed", "sprintBoosting", "sprinting", "<init>", "DaFlightPorted"})
public final class MovementHandler {
    @NotNull
    public static final MovementHandler INSTANCE = new MovementHandler();
    private static float moveForward;
    private static float moveStrafe;
    private static float maxFlySpeed;
    private static float maxWalkSpeed;
    private static boolean flying;
    private static boolean sprinting;
    private static boolean flyBoosting;
    private static boolean sprintBoosting;
    private static boolean ascending;
    private static boolean descending;

    private MovementHandler() {
    }

    public final float getMaxFlySpeed() {
        return maxFlySpeed;
    }

    public final void setMaxFlySpeed(float f) {
        maxFlySpeed = f;
    }

    public final float getMaxWalkSpeed() {
        return maxWalkSpeed;
    }

    public final void setMaxWalkSpeed(float f) {
        maxWalkSpeed = f;
    }

    @JvmStatic
    public static final void reset() {
        flying = false;
        sprinting = false;
        flyBoosting = false;
        sprintBoosting = false;
        maxFlySpeed = DaFlight.getSingleplayerState() ? 100000.0f : 1.0f;
        maxWalkSpeed = DaFlight.getSingleplayerState() ? 100000.0f : 1.0f;
    }

    @JvmStatic
    public static final void applyMovement(@NotNull Vector3D vec, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        if (flying && DaFlight.getConfig().getToggle()) {
            INSTANCE.moveFlying(vec, rotation);
        } else if (sprinting && DaFlight.getConfig().getToggle()) {
            INSTANCE.moveSprinting(vec, rotation);
        }
    }

    @JvmStatic
    public static final void setMovement(float moveForward, float moveStrafe) {
        MovementHandler.moveForward = moveForward;
        MovementHandler.moveStrafe = moveStrafe;
    }

    @JvmStatic
    public static final float jump(float original) {
        if (!sprinting || !DaFlight.getConfig().getToggle()) {
            return original;
        }
        float boost = sprintBoosting ? DaFlight.getConfig().getSprintBoost() : 1.0f;
        float speed = Math.min(DaFlight.getConfig().getSprintSpeed() * DaFlight.getConfig().getJumpModifier() * boost, maxWalkSpeed * 5.0f);
        return original * speed;
    }

    public final boolean isFlying() {
        return flying;
    }

    public final void setFlying(boolean state) {
        flying = state;
    }

    public final boolean isFlyBoosting() {
        return flyBoosting;
    }

    public final void setFlyBoosting(boolean state) {
        flyBoosting = state;
    }

    public final boolean isSprinting() {
        return sprinting;
    }

    public final void setSprinting(boolean state) {
        sprinting = state;
    }

    public final boolean isSprintBoosting() {
        return sprintBoosting;
    }

    public final void setSprintBoosting(boolean state) {
        sprintBoosting = state;
    }

    public final void setAscending(boolean state) {
        ascending = state;
    }

    public final void setDescending(boolean state) {
        descending = state;
    }

    @JvmStatic
    public static final boolean shouldDisableFov() {
        return DaFlight.getConfig().getDisableFov() && flying;
    }

    @JvmStatic
    public static final boolean shouldDisableViewBobbing() {
        return flying;
    }

    private final void moveFlying(Vector3D vec, Rotation rotation) {
        float strafeMod = DaFlight.getConfig().getStrafeModifier();
        float ascendMod = DaFlight.getConfig().getVerticalModifier();
        float boost = flyBoosting ? DaFlight.getConfig().getFlyBoost() : 1.0f;
        float speed = RangesKt.coerceAtMost((float)(DaFlight.getConfig().getFlySpeed() * boost), (float)maxFlySpeed);
        double pitch = Math.toRadians(rotation.getPitch());
        double yaw = Math.toRadians(rotation.getYaw());
        double dx = -Math.sin(yaw);
        double dz = Math.cos(yaw);
        vec.set(dx * (double)moveForward, 0.0, dz * (double)moveForward);
        vec.add(dz * (double)moveStrafe * (double)strafeMod, 0.0, -dx * (double)moveStrafe * (double)strafeMod);
        if (!DaFlight.isGameInactive()) {
            if (ascending) {
                vec.add(0.0, ascendMod, 0.0);
            }
            if (descending) {
                vec.add(0.0, -((double)ascendMod), 0.0);
            }
        }
        if (DaFlight.getConfig().getFlyMode() == FlightMode.THREE_DIMENSIONAL) {
            double vy = -Math.sin(pitch);
            double hy = Math.abs(Math.cos(pitch));
            vec.mult(hy, 1.0, hy);
            vec.add(0.0, vy * (double)moveForward * (double)ascendMod, 0.0);
        }
        vec.norm();
        vec.mult(speed);
    }

    private final void moveSprinting(Vector3D vec, Rotation rotation) {
        float strafeMod = DaFlight.getConfig().getStrafeModifier();
        float boost = sprintBoosting ? DaFlight.getConfig().getSprintBoost() : 1.0f;
        float speed = RangesKt.coerceAtMost((float)(DaFlight.getConfig().getSprintSpeed() * boost), (float)maxWalkSpeed);
        double rads = Math.toRadians(rotation.getYaw());
        double dx = -Math.sin(rads);
        double dz = Math.cos(rads);
        vec.add(dx * (double)moveForward, 0.0, dz * (double)moveForward);
        vec.add(dz * (double)moveStrafe * (double)strafeMod, 0.0, -dx * (double)moveStrafe * (double)strafeMod);
        vec.mult(speed, 1.0, speed);
    }

    static {
        maxFlySpeed = 10.0f;
        maxWalkSpeed = 10.0f;
    }
}

