/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Field;
import net.minecraft.class_2540;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypes;

public class CreativeNetworkField {
    public final Field field;
    public boolean nullable;
    public final NetworkFieldType type;

    public CreativeNetworkField(Field field, NetworkFieldType type) {
        this.field = field;
        this.nullable = field.isAnnotationPresent(CanBeNull.class);
        this.type = type;
    }

    public void write(CreativePacket packet, class_2540 buffer) {
        try {
            Object content = this.field.get(packet);
            if (this.nullable) {
                buffer.method_52964(content != null);
            }
            if (content != null) {
                this.type.write(content, this.field.getType(), this.field.getGenericType(), buffer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CreativeCore.LOGGER.error((Object)e);
        }
    }

    public void read(CreativePacket packet, class_2540 buffer) {
        try {
            Object content = this.nullable && !buffer.readBoolean() ? null : this.type.read(this.field.getType(), this.field.getGenericType(), buffer);
            this.field.set(packet, content);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CreativeCore.LOGGER.error((Object)e);
        }
    }

    public static CreativeNetworkField create(Field field) {
        NetworkFieldType parser = NetworkFieldTypes.get(field);
        if (parser != null) {
            return new CreativeNetworkField(field, parser);
        }
        return null;
    }
}

