/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.creator;

import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiCreator {
    public static final NamedHandlerRegistry<GuiCreator> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiCreatorItem ITEM_OPENER = GuiCreator.register("item", new GuiCreatorItem());
    public static final GuiCreatorBlock BLOCK_OPENER = GuiCreator.register("block", new GuiCreatorBlock());
    String name;
    public final BiFunction<class_2487, class_1657, GuiLayer> function;

    public static <T extends GuiCreator> T register(String name, T creator) {
        creator.name = name;
        REGISTRY.register(name, creator);
        return creator;
    }

    public GuiCreator(BiFunction<class_2487, class_1657, GuiLayer> function) {
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    protected void openGui(class_2487 nbt, class_1657 player) {
        if (player.method_37908().field_9236) {
            CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(this.name, nbt));
        } else {
            OpenGuiPacket.openGuiOnServer(this, nbt, (class_3222)player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void openClientSide(GuiLayer layer) {
        class_310.method_1551().method_29970((class_437)new GuiScreenIntegration(layer));
    }

    public static class GuiCreatorItem
    extends GuiCreator {
        public GuiCreatorItem() {
            super((nbt, player) -> {
                class_1268 hand = nbt.method_10577("main_hand") ? class_1268.field_5808 : class_1268.field_5810;
                class_1799 stack = player.method_5998(hand);
                class_1792 patt3158$temp = stack.method_7909();
                if (patt3158$temp instanceof ItemGuiCreator) {
                    ItemGuiCreator item = (ItemGuiCreator)patt3158$temp;
                    return item.create((class_2487)nbt, (class_1657)player);
                }
                return null;
            });
        }

        public void open(class_1657 player, class_1268 hand) {
            this.open(new class_2487(), player, hand);
        }

        public void open(class_2487 nbt, class_1657 player, class_1268 hand) {
            nbt.method_10556("main_hand", hand == class_1268.field_5808);
            this.openGui(nbt, player);
        }
    }

    public static class GuiCreatorBlock
    extends GuiCreator {
        public GuiCreatorBlock() {
            super((nbt, player) -> {
                class_2338 pos = new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z"));
                class_1937 level = player.method_37908();
                class_2680 state = level.method_8320(pos);
                class_2248 patt4058$temp = state.method_26204();
                if (patt4058$temp instanceof BlockGuiCreator) {
                    BlockGuiCreator block = (BlockGuiCreator)patt4058$temp;
                    return block.create((class_2487)nbt, level, pos, state, (class_1657)player);
                }
                return null;
            });
        }

        public void open(class_1657 player, class_2338 pos) {
            this.open(new class_2487(), player, pos);
        }

        public void open(class_2487 nbt, class_1657 player, class_2338 pos) {
            nbt.method_10569("x", pos.method_10263());
            nbt.method_10569("y", pos.method_10264());
            nbt.method_10569("z", pos.method_10260());
            this.openGui(nbt, player);
        }
    }

    public static class GuiCreatorBasic
    extends GuiCreator {
        public GuiCreatorBasic(BiFunction<class_2487, class_1657, GuiLayer> function) {
            super(function);
        }

        public void open(class_1657 player) {
            this.openGui(new class_2487(), player);
        }

        public void open(class_2487 nbt, class_1657 player) {
            this.openGui(nbt, player);
        }
    }
}

