/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium.mixin;

import dev.tr7zw.exordium.ExordiumModBase;
import dev.tr7zw.exordium.access.TablistAccess;
import dev.tr7zw.exordium.util.BufferedComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_355;
import net.minecraft.class_640;
import net.minecraft.class_9011;
import net.minecraft.class_9015;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_355.class})
public abstract class PlayerTabOverlayMixin
implements TablistAccess {
    @Shadow
    private class_310 field_2155;
    @Shadow
    private class_329 field_2157;
    @Shadow
    private Map<UUID, class_355.class_7732> field_40393;
    private ArrayList<Integer> playerInfoHashes = new ArrayList();
    private int headerHash = 0;
    private int footerHash = 0;
    private int scoreboardHash = 0;
    private int objectiveHash = 0;
    @Shadow
    private class_2561 field_2153;
    @Shadow
    private class_2561 field_2154;
    private class_266 lastTrackedObjective;
    private boolean outdated;
    private BufferedComponent playerlistBufferedComponent = new BufferedComponent(true, () -> ExordiumModBase.instance.config.tablistSettings){

        @Override
        public boolean needsRender() {
            return PlayerTabOverlayMixin.this.outdated;
        }

        @Override
        public void captureState() {
            PlayerTabOverlayMixin.this.playerInfoHashes = PlayerTabOverlayMixin.this.fastGetPlayerInfoListHashCode(PlayerTabOverlayMixin.this.method_48213());
            PlayerTabOverlayMixin.this.headerHash = PlayerTabOverlayMixin.this.field_2153 == null ? 0 : PlayerTabOverlayMixin.this.field_2153.getString().hashCode();
            PlayerTabOverlayMixin.this.footerHash = PlayerTabOverlayMixin.this.field_2154 == null ? 0 : PlayerTabOverlayMixin.this.field_2154.getString().hashCode();
        }
    };

    @Override
    public void updateState(class_269 scoreboard, class_266 objective) {
        boolean scoreboardOrObjectiveChange = this.scoreboardOrObjectiveChanged(scoreboard, objective);
        int newHeaderHash = this.field_2153 == null ? 0 : this.field_2153.getString().hashCode();
        int newFooterHash = this.field_2154 == null ? 0 : this.field_2154.getString().hashCode();
        boolean plaverInfoOutdated = !this.playerInfoHashes.equals(this.fastGetPlayerInfoListHashCode(this.method_48213()));
        this.outdated = plaverInfoOutdated || this.headerHash != newHeaderHash || this.footerHash != newFooterHash || scoreboardOrObjectiveChange;
    }

    public boolean scoreboardOrObjectiveChanged(class_269 scoreboard, class_266 objective) {
        int newObjectiveHashCode;
        if (objective == null && this.lastTrackedObjective == null) {
            return false;
        }
        int scoreboardHashCode = 1;
        for (class_9011 score : scoreboard.method_1184(objective)) {
            scoreboardHashCode = 31 * scoreboardHashCode + (score == null ? 0 : score.comp_2128());
        }
        int n = newObjectiveHashCode = objective == null ? 0 : objective.method_1113().hashCode();
        if (scoreboardHashCode == this.scoreboardHash && newObjectiveHashCode == this.objectiveHash) {
            return false;
        }
        this.scoreboardHash = scoreboardHashCode;
        this.objectiveHash = newObjectiveHashCode;
        this.lastTrackedObjective = objective;
        return true;
    }

    public ArrayList<Integer> fastGetPlayerInfoListHashCode(List<class_640> playerInfos) {
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        for (class_640 playerInfo : playerInfos) {
            class_1657 player;
            if (playerInfo == null) continue;
            int playerHash = playerInfo.method_2966().getId().hashCode();
            playerHash += playerInfo.method_2966().getName().hashCode();
            if (playerInfo.method_2971() != null) {
                playerHash += playerInfo.method_2971().getString().hashCode();
                playerHash += playerInfo.method_2971().method_10866().hashCode();
            } else {
                class_268 playerTeam = playerInfo.method_2955();
                if (playerTeam == null) continue;
                class_2561 prefix = playerTeam.method_1144();
                class_2561 suffix = playerTeam.method_1136();
                playerHash += Objects.hash(playerTeam.method_1202(), prefix.method_10866(), prefix.getString(), suffix.method_10866(), suffix.getString());
            }
            playerHash += playerInfo.method_2958() == class_1934.field_9219 ? 31 : 0;
            playerHash += playerInfo.method_52810().comp_1626().hashCode();
            playerHash += playerInfo.method_2959() * 63;
            if (this.lastTrackedObjective != null && this.lastTrackedObjective.method_1118() == class_274.class_275.field_1471 && (player = this.field_2155.field_1687.method_18470(playerInfo.method_2966().getId())) != null) {
                class_355.class_7732 healthState = this.field_40393.computeIfAbsent(playerInfo.method_2966().getId(), _uuid -> new class_355.class_7732(this.lastTrackedObjective.method_1117().method_1180((class_9015)player, this.lastTrackedObjective).method_55409()));
                playerHash += healthState.method_45598((long)this.field_2157.method_1738()) ? 63 : 127;
            }
            hashCodes.add(playerHash);
        }
        return hashCodes;
    }

    @Shadow
    public abstract List<class_640> method_48213();

    @Override
    public BufferedComponent getPlayerListOverlayBuffer() {
        return this.playerlistBufferedComponent;
    }
}

