/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import traben.tconfig.gui.entries.TConfigEntryValue;

public class TConfigEntryInt
extends TConfigEntryValue<Integer> {
    private final IntSliderWidget widget;
    private boolean modifiesOffMaxToMin = true;

    public TConfigEntryInt(@Translatable String text, @Translatable String tooltip, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max, boolean isMinOff, boolean isMaxOff) {
        super(text, tooltip, getter, setter, defaultValue);
        this.widget = new IntSliderWidget(this.getText(), getter.get(), this.getTooltip(), min, max, isMinOff, isMaxOff);
    }

    public TConfigEntryInt(@Translatable String text, @Translatable String tooltip, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max) {
        super(text, tooltip, getter, setter, defaultValue);
        this.widget = new IntSliderWidget(this.getText(), getter.get(), this.getTooltip(), min, max, false, false);
    }

    public TConfigEntryInt(@Translatable String text, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max, boolean isMinOff, boolean isMaxOff) {
        this(text, null, getter, setter, defaultValue, min, max, isMinOff, isMaxOff);
    }

    public TConfigEntryInt(@Translatable String text, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max) {
        this(text, null, getter, setter, defaultValue, min, max, false, false);
    }

    @Override
    protected Integer getValueFromWidget() {
        return this.widget.getValueRoundedToIntBetweenMinMax();
    }

    @Override
    public class_339 getWidget(int x, int y, int width, int height) {
        this.widget.method_55444(width, height, x, y);
        return this.widget;
    }

    @Override
    void setWidgetToDefaultValue() {
        this.widget.setValue((Integer)this.defaultValue);
    }

    @Override
    void resetWidgetToInitialValue() {
        this.widget.setValue((Integer)this.getter.get());
    }

    public TConfigEntryInt dontModifyOffMaxValues() {
        this.modifiesOffMaxToMin = false;
        return this;
    }

    public class IntSliderWidget
    extends class_357 {
        private final int max;
        private final int min;
        private final String title;
        private final boolean isMinOff;
        private final boolean isMaxOff;
        private final int difference;

        public IntSliderWidget(class_2561 text, int initialValue, class_7919 tooltip, int min, int max, boolean isMinOff, boolean isMaxOff) {
            super(0, 0, 20, 20, text, 0.0);
            this.min = min;
            this.max = max;
            this.isMinOff = isMinOff;
            this.isMaxOff = isMaxOff;
            this.difference = max - min;
            this.title = text.getString() + ": ";
            this.setValue(initialValue);
            this.method_47400(tooltip);
        }

        private boolean isOff() {
            if (this.isMinOff && this.field_22753 == 0.0) {
                return true;
            }
            return this.isMaxOff && this.field_22753 == 1.0;
        }

        private void setValue(int intIndex) {
            this.field_22753 = (double)(class_3532.method_15340((int)intIndex, (int)this.min, (int)this.max) - this.min) / (double)this.difference;
            this.method_25346();
        }

        protected void method_25346() {
            this.snapValueToNearestIndex();
            this.method_25355(class_2561.method_30163((String)(this.title + (this.getValueRoundedToIntBetweenMinMax() != ((Integer)TConfigEntryInt.this.getter.get()).intValue() ? "\u00a7a" : "") + (Serializable)(this.isOff() ? class_5244.field_24333.getString() : Integer.valueOf(this.getValueRoundedToIntBetweenMinMax())))));
        }

        protected void method_25344() {
        }

        private void snapValueToNearestIndex() {
            this.field_22753 = (double)((int)Math.round(this.field_22753 * (double)this.difference)) / (double)this.difference;
        }

        public int getValueRoundedToIntBetweenMinMax() {
            if (this.isOff() && TConfigEntryInt.this.modifiesOffMaxToMin) {
                return this.min;
            }
            return (int)Math.round(this.field_22753 * (double)this.difference) + this.min;
        }
    }
}

