/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5616;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.utils.ETFEntity;
import traben.tconfig.TConfig;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryCustomButton;
import traben.tconfig.gui.entries.TConfigEntryCustomScreenOpener;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;
import traben.tconfig.gui.entries.TConfigEntryInt;
import traben.tconfig.gui.entries.TConfigEntryText;

public final class ETFConfig
extends TConfig {
    public IllegalPathMode illegalPathSupportMode = IllegalPathMode.None;
    public boolean enableCustomTextures = true;
    public boolean enableCustomBlockEntities = true;
    public UpdateFrequency textureUpdateFrequency_V2 = UpdateFrequency.Fast;
    public boolean enableEmissiveTextures = true;
    public boolean enableEnchantedTextures = true;
    public boolean enableEmissiveBlockEntities = true;
    public EmissiveRenderModes emissiveRenderMode = EmissiveRenderModes.DULL;
    public boolean alwaysCheckVanillaEmissiveSuffix = true;
    public boolean enableArmorAndTrims = true;
    public boolean skinFeaturesEnabled = true;
    public boolean skinFeaturesEnableTransparency = true;
    public boolean skinFeaturesEnableFullTransparency = false;
    public boolean tryETFTransparencyForAllSkins = false;
    public boolean enableEnemyTeamPlayersSkinFeatures = true;
    public boolean enableBlinking = true;
    public int blinkFrequency = 150;
    public int blinkLength = 1;
    public double advanced_IncreaseCacheSizeModifier = 1.0;
    public DebugLogMode debugLoggingMode = DebugLogMode.None;
    public boolean logTextureDataInitialization = false;
    public boolean hideConfigButton = false;
    public boolean disableVanillaDirectoryVariantTextures = false;
    public boolean use3DSkinLayerPatch = true;
    public boolean enableFullBodyWardenTextures = true;
    public String2BooleanNullMap entityEmissiveOverrides = new String2BooleanNullMap();
    public ObjectOpenHashSet<String> propertiesDisabled = new ObjectOpenHashSet();
    public ObjectOpenHashSet<String> propertyInvertUpdatingOverrides = new ObjectOpenHashSet();
    public String2BooleanNullMap entityRandomOverrides = new String2BooleanNullMap();
    public String2EnumNullMap<EmissiveRenderModes> entityEmissiveBrightOverrides = new String2EnumNullMap();
    public String2EnumNullMap<RenderLayerOverride> entityRenderLayerOverrides = new String2EnumNullMap();
    public Object2IntOpenHashMap<String> entityLightOverrides = new Object2IntOpenHashMap();

    public boolean isPropertyDisabled(@NotNull RandomProperties.RandomPropertyFactory property) {
        return this.propertiesDisabled.contains((Object)property.getPropertyId());
    }

    public boolean canPropertyUpdate(@NotNull RandomProperties.RandomPropertyFactory property) {
        return this.propertyInvertUpdatingOverrides.contains((Object)property.getPropertyId()) != property.updatesOverTime();
    }

    public boolean canDoCustomTextures() {
        if (this.entityRandomOverrides.isEmpty() || ETFRenderContext.getCurrentEntity() == null) {
            return this.enableCustomTextures;
        }
        String key = ETFRenderContext.getCurrentEntity().etf$getEntityKey();
        if (key != null && this.entityRandomOverrides.containsKey(key)) {
            return this.entityRandomOverrides.getBoolean(key);
        }
        return this.enableCustomTextures;
    }

    public boolean canDoEmissiveTextures() {
        if (this.entityEmissiveOverrides.isEmpty() || ETFRenderContext.getCurrentEntity() == null) {
            return this.enableEmissiveTextures;
        }
        String key = ETFRenderContext.getCurrentEntity().etf$getEntityKey();
        if (key != null && this.entityEmissiveOverrides.containsKey(key)) {
            return this.entityEmissiveOverrides.getBoolean(key);
        }
        return this.enableEmissiveTextures;
    }

    public EmissiveRenderModes getEmissiveRenderMode() {
        if (this.entityEmissiveBrightOverrides.isEmpty() || ETFRenderContext.getCurrentEntity() == null) {
            return this.emissiveRenderMode;
        }
        String key = ETFRenderContext.getCurrentEntity().etf$getEntityKey();
        if (key != null && this.entityEmissiveBrightOverrides.containsKey(key)) {
            return (EmissiveRenderModes)((Object)this.entityEmissiveBrightOverrides.get(key));
        }
        return this.emissiveRenderMode;
    }

    public RenderLayerOverride getRenderLayerOverride() {
        if (this.entityRenderLayerOverrides.isEmpty() || ETFRenderContext.getCurrentEntity() == null) {
            return null;
        }
        String key = ETFRenderContext.getCurrentEntity().etf$getEntityKey();
        if (key != null && this.entityRenderLayerOverrides.containsKey(key)) {
            return (RenderLayerOverride)((Object)this.entityRenderLayerOverrides.get(key));
        }
        return null;
    }

    public int getLightOverride(class_1297 entity, float tickDelta, int light) {
        if (this.entityLightOverrides.isEmpty() || entity == null) {
            return light;
        }
        String key = ((ETFEntity)entity).etf$getEntityKey();
        if (key != null && this.entityLightOverrides.containsKey((Object)key)) {
            int lightETF = class_3532.method_15340((int)this.entityLightOverrides.get((Object)key), (int)0, (int)15);
            class_2338 pos = class_2338.method_49638((class_2374)entity.method_31166(tickDelta));
            int block = entity.method_37908().method_8314(class_1944.field_9284, pos);
            int sky = entity.method_5809() ? 15 : entity.method_37908().method_8314(class_1944.field_9282, pos);
            return class_765.method_23687((int)Math.max(block, sky), (int)lightETF);
        }
        return light;
    }

    public int getLightOverrideBE(int light) {
        if (this.entityLightOverrides.isEmpty() || ETFRenderContext.getCurrentEntity() == null) {
            return light;
        }
        String key = ETFRenderContext.getCurrentEntity().etf$getEntityKey();
        if (key != null && this.entityLightOverrides.containsKey((Object)key)) {
            int lightETF = class_3532.method_15340((int)this.entityLightOverrides.get((Object)key), (int)0, (int)15);
            class_1937 world = ETFRenderContext.getCurrentEntity().etf$getWorld();
            class_2338 pos = ETFRenderContext.getCurrentEntity().etf$getBlockPos();
            if (world == null || pos == null) {
                return light;
            }
            int block = world.method_8314(class_1944.field_9282, pos);
            int sky = world.method_8314(class_1944.field_9284, pos);
            return class_765.method_23687((int)Math.max(block, sky), (int)lightETF);
        }
        return light;
    }

    @Override
    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntryCategory("config.entity_features.textures_main").add(new TConfigEntryCategory("config.entity_texture_features.random_settings.title").add(new TConfigEntryBoolean("config.entity_texture_features.enable_custom_textures.title", "config.entity_texture_features.enable_custom_textures.tooltip", () -> this.enableCustomTextures, aBoolean -> {
            this.enableCustomTextures = aBoolean;
        }, true), new TConfigEntryEnumSlider<UpdateFrequency>("config.entity_texture_features.texture_update_frequency.title", "config.entity_texture_features.texture_update_frequency.tooltip", () -> this.textureUpdateFrequency_V2, updateFrequency -> {
            this.textureUpdateFrequency_V2 = updateFrequency;
        }, UpdateFrequency.Fast), new TConfigEntryBoolean("config.entity_texture_features.custom_block_entity.title", "config.entity_texture_features.custom_block_entity.tooltip", () -> this.enableCustomBlockEntities, aBoolean -> {
            this.enableCustomBlockEntities = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_texture_features.disable_default_directory.title", "config.entity_texture_features.disable_default_directory.tooltip", () -> this.disableVanillaDirectoryVariantTextures, aBoolean -> {
            this.disableVanillaDirectoryVariantTextures = aBoolean;
        }, false)), new TConfigEntryCategory("config.entity_texture_features.emissive_settings.title").add(new TConfigEntryBoolean("config.entity_texture_features.enable_emissive_textures.title", "config.entity_texture_features.enable_emissive_textures.tooltip", () -> this.enableEmissiveTextures, aBoolean -> {
            this.enableEmissiveTextures = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_texture_features.emissive_block_entity.title", "config.entity_texture_features.emissive_block_entity.tooltip", () -> this.enableEmissiveBlockEntities, aBoolean -> {
            this.enableEmissiveBlockEntities = aBoolean;
        }, true), new TConfigEntryEnumButton<EmissiveRenderModes>("config.entity_texture_features.emissive_mode.title", "config.entity_texture_features.emissive_mode.tooltip", () -> this.emissiveRenderMode, renderMode -> {
            this.emissiveRenderMode = renderMode;
        }, EmissiveRenderModes.DULL), new TConfigEntryBoolean("config.entity_texture_features.always_check_vanilla_emissive_suffix.title", "config.entity_texture_features.always_check_vanilla_emissive_suffix.tooltip", () -> this.alwaysCheckVanillaEmissiveSuffix, aBoolean -> {
            this.alwaysCheckVanillaEmissiveSuffix = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_texture_features.armor_enable", "config.entity_texture_features.armor_enable.tooltip", () -> this.enableArmorAndTrims, aBoolean -> {
            this.enableArmorAndTrims = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_texture_features.enchanted_enable", "config.entity_texture_features.enchanted_enable.tooltip", () -> this.enableEnchantedTextures, aBoolean -> {
            this.enableEnchantedTextures = aBoolean;
        }, true)), new TConfigEntryCategory("config.entity_texture_features.player_skin_settings.title").add(new TConfigEntryBoolean("config.entity_texture_features.player_skin_features.title", "config.entity_texture_features.player_skin_features.tooltip", () -> this.skinFeaturesEnabled, aBoolean -> {
            this.skinFeaturesEnabled = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_texture_features.skin_features_enable_transparency.title", "config.entity_texture_features.skin_features_enable_transparency.tooltip", () -> this.skinFeaturesEnableTransparency, aBoolean -> {
            this.skinFeaturesEnableTransparency = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_texture_features.skin_features_enable_full_transparency.title", "config.entity_texture_features.skin_features_enable_full_transparency.tooltip", () -> this.skinFeaturesEnableFullTransparency, aBoolean -> {
            this.skinFeaturesEnableFullTransparency = aBoolean;
        }, false), new TConfigEntryBoolean("config.entity_texture_features.skin_features_try_transparency_for_all.title", "config.entity_texture_features.skin_features_try_transparency_for_all.tooltip", () -> this.tryETFTransparencyForAllSkins, aBoolean -> {
            this.tryETFTransparencyForAllSkins = aBoolean;
        }, false), new TConfigEntryBoolean("config.entity_texture_features.enable_enemy_team_players_skin_features.title", "config.entity_texture_features.enable_enemy_team_players_skin_features.tooltip", () -> this.enableEnemyTeamPlayersSkinFeatures, aBoolean -> {
            this.enableEnemyTeamPlayersSkinFeatures = aBoolean;
        }, true), ETF.SKIN_LAYERS_DETECTED ? new TConfigEntryBoolean("config.entity_texture_features.skin_layers_patch.title", "config.entity_texture_features.skin_layers_patch.tooltip", () -> this.use3DSkinLayerPatch, aBoolean -> {
            this.use3DSkinLayerPatch = aBoolean;
        }, true) : null, this.getPlayerSkinEditorButton()), new TConfigEntryCategory("config.entity_texture_features.blinking_mob_settings_sub.title").add(new TConfigEntryBoolean("config.entity_texture_features.blinking_mob_settings.title", "config.entity_texture_features.blinking_mob_settings.tooltip", () -> this.enableBlinking, aBoolean -> {
            this.enableBlinking = aBoolean;
        }, true), new TConfigEntryInt("config.entity_texture_features.blink_frequency.title", "config.entity_texture_features.blink_frequency.tooltip", () -> this.blinkFrequency, aInt -> {
            this.blinkFrequency = aInt;
        }, 150, 1, 1024), new TConfigEntryInt("config.entity_texture_features.blink_length.title", "config.entity_texture_features.blink_length.tooltip", () -> this.blinkLength, aInt -> {
            this.blinkLength = aInt;
        }, 1, 1, 20)), new TConfigEntryCategory("config.entity_texture_features.debug_screen.title").add(new TConfigEntryEnumButton<DebugLogMode>("config.entity_texture_features.debug_logging_mode.title", "config.entity_texture_features.debug_logging_mode.tooltip", () -> this.debugLoggingMode, debugLogMode -> {
            this.debugLoggingMode = debugLogMode;
        }, DebugLogMode.None), new TConfigEntryBoolean("config.entity_texture_features.log_creation", "config.entity_texture_features.log_creation.tooltip", () -> this.logTextureDataInitialization, aBoolean -> {
            this.logTextureDataInitialization = aBoolean;
        }, false), new TConfigEntryCustomButton("config.entity_texture_features.debug_screen.mass_log", "config.entity_texture_features.debug_screen.mass_log.tooltip", button -> {
            ETFManager.getInstance().doTheBigBoyPrintoutKronk();
            button.method_25355(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.debug_screen.mass_log.done"));
            button.field_22763 = false;
        }))), new TConfigEntryCategory("config.entity_features.general_settings.title").add(new TConfigEntryEnumButton<IllegalPathMode>("config.entity_texture_features.allow_illegal_texture_paths.title", "config.entity_texture_features.allow_illegal_texture_paths.tooltip", () -> this.illegalPathSupportMode, illegalPathMode -> {
            this.illegalPathSupportMode = illegalPathMode;
        }, IllegalPathMode.None), new TConfigEntryBoolean("config.entity_texture_features.warden.title", "config.entity_texture_features.warden.tooltip", () -> this.enableFullBodyWardenTextures, aBoolean -> {
            this.enableFullBodyWardenTextures = aBoolean;
        }, true), new TConfigEntryBoolean("config.entity_features.hide_button", "config.entity_features.hide_button.tooltip", () -> this.hideConfigButton, aBoolean -> {
            this.hideConfigButton = aBoolean;
        }, false)), new TConfigEntryCategory("config.entity_texture_features.restrict_update_properties2").addAll(this.getPropertySettings()), this.getEntitySettings());
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            class_7923.field_41177.forEach(entityType -> {
                if (entityType == class_1299.field_6097) {
                    return;
                }
                String translationKey = entityType.method_5882();
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
            TConfigEntryText warn = new TConfigEntryText("config.entity_features.per_entity_settings.blocks");
            TConfigEntryText warn2 = new TConfigEntryText("config.entity_features.per_entity_settings.blocks2");
            category.add(warn, warn2);
            class_5616.field_27752.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey(entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey).add(warn, warn2);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return category;
    }

    private void addEntityConfigs(TConfigEntryCategory entityCategory, String translationKey) {
        entityCategory.add(new TConfigEntryCategory("config.entity_features.textures_main").add(new TConfigEntryEnumButton<OverrideBooleanType>("config.entity_texture_features.enable_emissive_textures.title", "config.entity_texture_features.enable_emissive_textures.tooltip", () -> this.entityEmissiveOverrides.getNullable(translationKey), overrideBooleanType -> this.entityEmissiveOverrides.putNullable(translationKey, (OverrideBooleanType)((Object)overrideBooleanType)), null, OverrideBooleanType.class), new TConfigEntryEnumButton<OverrideBooleanType>("config.entity_texture_features.enable_custom_textures.title", "config.entity_texture_features.enable_custom_textures.tooltip", () -> this.entityRandomOverrides.getNullable(translationKey), overrideBooleanType -> this.entityRandomOverrides.putNullable(translationKey, (OverrideBooleanType)((Object)overrideBooleanType)), null, OverrideBooleanType.class), new TConfigEntryEnumButton<EmissiveRenderModes>("config.entity_texture_features.emissive_mode.title", "config.entity_texture_features.emissive_mode.tooltip", () -> this.entityEmissiveBrightOverrides.getNullable(translationKey), mode -> this.entityEmissiveBrightOverrides.putNullable(translationKey, (EmissiveRenderModes)((Object)mode)), null, EmissiveRenderModes.class), new TConfigEntryEnumButton<RenderLayerOverride>("config.entity_features.per_entity_settings.layer", "config.entity_features.per_entity_settings.layer.tooltip", () -> this.entityRenderLayerOverrides.getNullable(translationKey), layer -> this.entityRenderLayerOverrides.putNullable(translationKey, (RenderLayerOverride)((Object)layer)), null, RenderLayerOverride.class)), new TConfigEntryInt("config.entity_features.per_entity_settings.light", "config.entity_features.per_entity_settings.light.tooltip", () -> this.entityLightOverrides.getOrDefault((Object)translationKey, -1), light -> {
            if (light == -1) {
                this.entityLightOverrides.removeInt((Object)translationKey);
                return;
            }
            this.entityLightOverrides.put((Object)translationKey, light);
        }, -1, -1, 15, true, false));
    }

    private List<TConfigEntry> getPropertySettings() {
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        RandomProperties.forEachProperty(propertySettings -> {
            boolean defaultNoUpdate = !propertySettings.updatesOverTime();
            String id = propertySettings.getPropertyId();
            TConfigEntryCategory category = new TConfigEntryCategory(id);
            list.add(category);
            category.add(new TConfigEntryBoolean("config.entity_texture_features.restrict_update_properties.allow", "config.entity_texture_features.restrict_update_properties.allow.tooltip", () -> !this.propertiesDisabled.contains((Object)id), aBoolean -> {
                if (aBoolean.booleanValue()) {
                    this.propertiesDisabled.remove((Object)id);
                } else {
                    this.propertiesDisabled.add((Object)id);
                }
            }, true), new TConfigEntryBoolean("config.entity_texture_features.restrict_update_properties.lock", "config.entity_texture_features.restrict_update_properties.lock.tooltip", () -> this.propertyInvertUpdatingOverrides.contains((Object)id) != defaultNoUpdate, aBoolean -> {
                if (aBoolean != defaultNoUpdate) {
                    this.propertyInvertUpdatingOverrides.add((Object)id);
                } else {
                    this.propertyInvertUpdatingOverrides.remove((Object)id);
                }
            }, defaultNoUpdate)).addAll(TConfigEntryText.fromLongOrMultilineTranslation(propertySettings.getExplanationTranslationKey(), 200, TConfigEntryText.TextAlignment.LEFT));
        });
        return list;
    }

    private TConfigEntry getPlayerSkinEditorButton() {
        boolean condition1 = ETF.config().getConfig().skinFeaturesEnabled;
        boolean condition2 = !ETFVersionDifferenceHandler.isFabric() || ETFVersionDifferenceHandler.isThisModLoaded("fabric");
        boolean condition3 = class_310.method_1551().field_1724 != null;
        boolean condition4 = ETFPlayerTexture.clientPlayerOriginalSkinImageForTool != null;
        boolean canLaunchSkinTool = condition1 && condition2 && condition3 && condition4;
        StringBuilder reasonText = new StringBuilder();
        if (!canLaunchSkinTool) {
            reasonText.append(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.reason_0").getString());
            if (!condition1) {
                reasonText.append(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.reason_1").getString());
            }
            if (!condition2) {
                reasonText.append(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.reason_2").getString());
            }
            if (!condition3) {
                reasonText.append(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.reason_3").getString());
            }
            if (!condition4) {
                reasonText.append(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.reason_4").getString());
            }
        }
        return canLaunchSkinTool ? new TConfigEntryCustomScreenOpener("config.entity_texture_features.player_skin_editor.button.enabled", reasonText.toString(), () -> new ETFConfigScreenSkinTool(class_310.method_1551().field_1755), false) : new TConfigEntryCustomScreenOpener("config.entity_texture_features.player_skin_editor.button.disabled", reasonText.toString(), () -> new ETFConfigScreenSkinTool(class_310.method_1551().field_1755), false).setEnabled(false);
    }

    @Override
    public class_2960 getModIcon() {
        return new class_2960("entity_texture_features", "textures/gui/icon.png");
    }

    public static enum IllegalPathMode {
        None("options.off"),
        Entity("config.entity_texture_features.illegal_path_mode.entity"),
        All("config.entity_texture_features.illegal_path_mode.all");

        private final String key;

        private IllegalPathMode(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }
    }

    public static enum UpdateFrequency {
        Never(-1, "config.entity_texture_features.update_frequency.never"),
        Slow(80, "config.entity_texture_features.update_frequency.slow"),
        Average(20, "config.entity_texture_features.update_frequency.average"),
        Fast(5, "config.entity_texture_features.update_frequency.fast"),
        Instant(1, "config.entity_texture_features.update_frequency.instant");

        private final int delay;
        private final String key;

        private UpdateFrequency(int delay, String key) {
            this.delay = delay;
            this.key = key;
        }

        public int getDelay() {
            return this.delay;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }
    }

    public static enum EmissiveRenderModes {
        DULL,
        BRIGHT;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DULL -> ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.emissive_mode.dull").getString();
                case BRIGHT -> ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.emissive_mode.bright").getString();
            };
        }
    }

    public static enum DebugLogMode {
        None("config.entity_texture_features.Debug_log_mode.none"),
        Log("config.entity_texture_features.Debug_log_mode.log"),
        Chat("config.entity_texture_features.Debug_log_mode.chat");

        private final String key;

        private DebugLogMode(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }
    }

    public static class String2BooleanNullMap
    extends Object2BooleanOpenHashMap<String> {
        public String2BooleanNullMap() {
            this.defaultReturnValue(false);
        }

        public void putNullable(String s, OverrideBooleanType v) {
            if (v == null) {
                this.removeBoolean(s);
                return;
            }
            super.put((Object)s, v == OverrideBooleanType.TRUE);
        }

        public OverrideBooleanType getNullable(String s) {
            if (this.getBoolean(s)) {
                return OverrideBooleanType.TRUE;
            }
            if (this.containsKey(s)) {
                return OverrideBooleanType.FALSE;
            }
            return null;
        }
    }

    public static class String2EnumNullMap<E extends Enum<E>>
    extends Object2ObjectOpenHashMap<String, E> {
        public void putNullable(String s, E v) {
            if (v == null) {
                this.remove(s);
                return;
            }
            super.put((Object)s, v);
        }

        public E getNullable(String s) {
            if (this.containsKey(s)) {
                return (E)((Enum)this.get(s));
            }
            return null;
        }
    }

    public static enum RenderLayerOverride {
        TRANSLUCENT("config.entity_texture_features.render_layer.translucent"),
        TRANSLUCENT_CULL("config.entity_texture_features.render_layer.translucent_cull"),
        END("config.entity_texture_features.render_layer.end"),
        OUTLINE("config.entity_texture_features.render_layer.outline");

        private final String key;

        private RenderLayerOverride(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }
    }

    public static enum OverrideBooleanType {
        TRUE,
        FALSE;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case TRUE -> class_5244.field_24332.getString();
                case FALSE -> class_5244.field_24333.getString();
            };
        }
    }
}

