/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

public final class GSONUtils {
    public static final Gson GSON = new Gson();

    private GSONUtils() {
        throw new AssertionError((Object)"No instances.");
    }

    public static boolean getBooleanOrThrow(JsonObject json, String key) {
        try {
            return json.get(key).getAsBoolean();
        }
        catch (Throwable t) {
            throw new JsonParseException("Expected to have boolean '" + key + "': " + json, t);
        }
    }

    public static int getIntOrThrow(JsonObject json, String key) {
        try {
            return json.get(key).getAsInt();
        }
        catch (Throwable t) {
            throw new JsonParseException("Expected to have int '" + key + "': " + json, t);
        }
    }

    public static long getLongOrThrow(JsonObject json, String key) {
        try {
            return json.get(key).getAsLong();
        }
        catch (Throwable t) {
            throw new JsonParseException("Expected to have long '" + key + "': " + json, t);
        }
    }

    public static String getStringOrThrow(JsonObject json, String key) {
        try {
            return json.get(key).getAsString();
        }
        catch (Throwable t) {
            throw new JsonParseException("Expected to have string '" + key + "': " + json, t);
        }
    }

    public static JsonObject getObjectOrThrow(JsonObject json, String key) {
        try {
            return json.get(key).getAsJsonObject();
        }
        catch (Throwable t) {
            throw new JsonParseException("Expected to have object '" + key + "': " + json, t);
        }
    }

    public static JsonArray getArrayOrThrow(JsonObject json, String key) {
        try {
            return json.get(key).getAsJsonArray();
        }
        catch (Throwable t) {
            throw new JsonParseException("Expected to have array '" + key + "': " + json, t);
        }
    }
}

