/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.crypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.security.SecureRandom;
import ru.vidtu.ias.crypt.Crypt;

public final class PasswordCrypt
implements Crypt {
    private final String password;

    public PasswordCrypt(String password) {
        this.password = password;
    }

    @Override
    public boolean insecure() {
        return false;
    }

    @Override
    public byte[] encrypt(byte[] decrypted) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SecureRandom random = SecureRandom.getInstanceStrong();
            byte[] salt = new byte[128];
            random.nextBytes(salt);
            out.write(salt);
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            out.write(iv);
            byte[] data = Crypt.pbkdfAesEncrypt(decrypted, this.password, salt, iv);
            out.write(data);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to encrypt using PasswordCrypt.", t);
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public byte[] decrypt(byte[] encrypted) {
        byte[] byArray;
        ByteArrayInputStream in = new ByteArrayInputStream(encrypted);
        try {
            byte[] salt = new byte[128];
            int read = in.read(salt);
            if (read != 128) {
                throw new EOFException("Not enough salt bytes: " + read);
            }
            byte[] iv = new byte[16];
            read = in.read(iv);
            if (read != 16) {
                throw new EOFException("Not enough IV bytes: " + read);
            }
            byte[] data = in.readAllBytes();
            byArray = Crypt.pbkdfAesDecrypt(data, this.password, salt, iv);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to decrypt using PasswordCrypt.", t);
            }
        }
        in.close();
        return byArray;
    }

    public String toString() {
        return "PasswordCrypt{password='[PASSWORD]'}";
    }
}

